@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketV2CorsRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property allowedHeaders List of headers allowed.
 * @property allowedMethods One or more HTTP methods that you allow the origin to execute. Can be `GET`, `PUT`, `POST`, `DELETE` or `HEAD`.
 * @property allowedOrigins One or more origins you want customers to be able to access the bucket from.
 * @property exposeHeaders One or more headers in the response that you want customers to be able to access from their applications (for example, from a JavaScript `XMLHttpRequest` object).
 * @property maxAgeSeconds Specifies time in seconds that browser can cache the response for a preflight request.
 */
public data class BucketV2CorsRuleArgs(
    public val allowedHeaders: Output<List<String>>? = null,
    public val allowedMethods: Output<List<String>>,
    public val allowedOrigins: Output<List<String>>,
    public val exposeHeaders: Output<List<String>>? = null,
    public val maxAgeSeconds: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketV2CorsRuleArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketV2CorsRuleArgs =
        com.pulumi.aws.s3.inputs.BucketV2CorsRuleArgs.builder()
            .allowedHeaders(allowedHeaders?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .allowedMethods(allowedMethods.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .allowedOrigins(allowedOrigins.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .exposeHeaders(exposeHeaders?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .maxAgeSeconds(maxAgeSeconds?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketV2CorsRuleArgs].
 */
@PulumiTagMarker
public class BucketV2CorsRuleArgsBuilder internal constructor() {
    private var allowedHeaders: Output<List<String>>? = null

    private var allowedMethods: Output<List<String>>? = null

    private var allowedOrigins: Output<List<String>>? = null

    private var exposeHeaders: Output<List<String>>? = null

    private var maxAgeSeconds: Output<Int>? = null

    /**
     * @param value List of headers allowed.
     */
    @JvmName("snrflcllhuhjopib")
    public suspend fun allowedHeaders(`value`: Output<List<String>>) {
        this.allowedHeaders = value
    }

    @JvmName("kllnsbwohqfkgvuu")
    public suspend fun allowedHeaders(vararg values: Output<String>) {
        this.allowedHeaders = Output.all(values.asList())
    }

    /**
     * @param values List of headers allowed.
     */
    @JvmName("swlqebfcytebcnfm")
    public suspend fun allowedHeaders(values: List<Output<String>>) {
        this.allowedHeaders = Output.all(values)
    }

    /**
     * @param value One or more HTTP methods that you allow the origin to execute. Can be `GET`, `PUT`, `POST`, `DELETE` or `HEAD`.
     */
    @JvmName("kdjmvkjqetmfudbf")
    public suspend fun allowedMethods(`value`: Output<List<String>>) {
        this.allowedMethods = value
    }

    @JvmName("jmqkvjfxqmorwpcy")
    public suspend fun allowedMethods(vararg values: Output<String>) {
        this.allowedMethods = Output.all(values.asList())
    }

    /**
     * @param values One or more HTTP methods that you allow the origin to execute. Can be `GET`, `PUT`, `POST`, `DELETE` or `HEAD`.
     */
    @JvmName("oyhctyuorjkgtdqv")
    public suspend fun allowedMethods(values: List<Output<String>>) {
        this.allowedMethods = Output.all(values)
    }

    /**
     * @param value One or more origins you want customers to be able to access the bucket from.
     */
    @JvmName("fuvbxyyuminhganx")
    public suspend fun allowedOrigins(`value`: Output<List<String>>) {
        this.allowedOrigins = value
    }

    @JvmName("nwtjyhpshguehark")
    public suspend fun allowedOrigins(vararg values: Output<String>) {
        this.allowedOrigins = Output.all(values.asList())
    }

    /**
     * @param values One or more origins you want customers to be able to access the bucket from.
     */
    @JvmName("pcfhrdikrbrkcvog")
    public suspend fun allowedOrigins(values: List<Output<String>>) {
        this.allowedOrigins = Output.all(values)
    }

    /**
     * @param value One or more headers in the response that you want customers to be able to access from their applications (for example, from a JavaScript `XMLHttpRequest` object).
     */
    @JvmName("igiyjkxuigalwrfw")
    public suspend fun exposeHeaders(`value`: Output<List<String>>) {
        this.exposeHeaders = value
    }

    @JvmName("xiyyftviiadlyuwh")
    public suspend fun exposeHeaders(vararg values: Output<String>) {
        this.exposeHeaders = Output.all(values.asList())
    }

    /**
     * @param values One or more headers in the response that you want customers to be able to access from their applications (for example, from a JavaScript `XMLHttpRequest` object).
     */
    @JvmName("oferpsgbohcxvayu")
    public suspend fun exposeHeaders(values: List<Output<String>>) {
        this.exposeHeaders = Output.all(values)
    }

    /**
     * @param value Specifies time in seconds that browser can cache the response for a preflight request.
     */
    @JvmName("jkxlwhutxdfhqcge")
    public suspend fun maxAgeSeconds(`value`: Output<Int>) {
        this.maxAgeSeconds = value
    }

    /**
     * @param value List of headers allowed.
     */
    @JvmName("ptmutjtxbkrqgixi")
    public suspend fun allowedHeaders(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowedHeaders = mapped
    }

    /**
     * @param values List of headers allowed.
     */
    @JvmName("hvdyesacnsxbnryx")
    public suspend fun allowedHeaders(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedHeaders = mapped
    }

    /**
     * @param value One or more HTTP methods that you allow the origin to execute. Can be `GET`, `PUT`, `POST`, `DELETE` or `HEAD`.
     */
    @JvmName("exrbcbcavmoowtag")
    public suspend fun allowedMethods(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedMethods = mapped
    }

    /**
     * @param values One or more HTTP methods that you allow the origin to execute. Can be `GET`, `PUT`, `POST`, `DELETE` or `HEAD`.
     */
    @JvmName("ycvpatbheiadoolq")
    public suspend fun allowedMethods(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedMethods = mapped
    }

    /**
     * @param value One or more origins you want customers to be able to access the bucket from.
     */
    @JvmName("ffruohmsphkqdens")
    public suspend fun allowedOrigins(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedOrigins = mapped
    }

    /**
     * @param values One or more origins you want customers to be able to access the bucket from.
     */
    @JvmName("keaccokhjyrpjlxd")
    public suspend fun allowedOrigins(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedOrigins = mapped
    }

    /**
     * @param value One or more headers in the response that you want customers to be able to access from their applications (for example, from a JavaScript `XMLHttpRequest` object).
     */
    @JvmName("cjkbguoighptoknx")
    public suspend fun exposeHeaders(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exposeHeaders = mapped
    }

    /**
     * @param values One or more headers in the response that you want customers to be able to access from their applications (for example, from a JavaScript `XMLHttpRequest` object).
     */
    @JvmName("wqmbaebpkijpggbi")
    public suspend fun exposeHeaders(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.exposeHeaders = mapped
    }

    /**
     * @param value Specifies time in seconds that browser can cache the response for a preflight request.
     */
    @JvmName("rqlprqtpoprorgwk")
    public suspend fun maxAgeSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxAgeSeconds = mapped
    }

    internal fun build(): BucketV2CorsRuleArgs = BucketV2CorsRuleArgs(
        allowedHeaders = allowedHeaders,
        allowedMethods = allowedMethods ?: throw PulumiNullFieldException("allowedMethods"),
        allowedOrigins = allowedOrigins ?: throw PulumiNullFieldException("allowedOrigins"),
        exposeHeaders = exposeHeaders,
        maxAgeSeconds = maxAgeSeconds,
    )
}
