@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketV2LifecycleRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property abortIncompleteMultipartUploadDays Specifies the number of days after initiating a multipart upload when the multipart upload must be completed.
 * @property enabled Specifies lifecycle rule status.
 * @property expirations Specifies a period in the object's expire. See Expiration below for details.
 * @property id Unique identifier for the rule. Must be less than or equal to 255 characters in length.
 * @property noncurrentVersionExpirations Specifies when noncurrent object versions expire. See Noncurrent Version Expiration below for details.
 * @property noncurrentVersionTransitions Specifies when noncurrent object versions transitions. See Noncurrent Version Transition below for details.
 * @property prefix Object key prefix identifying one or more objects to which the rule applies.
 * @property tags Specifies object tags key and value.
 * @property transitions Specifies a period in the object's transitions. See Transition below for details.
 */
public data class BucketV2LifecycleRuleArgs(
    public val abortIncompleteMultipartUploadDays: Output<Int>? = null,
    public val enabled: Output<Boolean>,
    public val expirations: Output<List<BucketV2LifecycleRuleExpirationArgs>>? = null,
    public val id: Output<String>? = null,
    public val noncurrentVersionExpirations:
    Output<List<BucketV2LifecycleRuleNoncurrentVersionExpirationArgs>>? = null,
    public val noncurrentVersionTransitions:
    Output<List<BucketV2LifecycleRuleNoncurrentVersionTransitionArgs>>? = null,
    public val prefix: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val transitions: Output<List<BucketV2LifecycleRuleTransitionArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketV2LifecycleRuleArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketV2LifecycleRuleArgs =
        com.pulumi.aws.s3.inputs.BucketV2LifecycleRuleArgs.builder()
            .abortIncompleteMultipartUploadDays(
                abortIncompleteMultipartUploadDays?.applyValue({ args0 ->
                    args0
                }),
            )
            .enabled(enabled.applyValue({ args0 -> args0 }))
            .expirations(
                expirations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .id(id?.applyValue({ args0 -> args0 }))
            .noncurrentVersionExpirations(
                noncurrentVersionExpirations?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .noncurrentVersionTransitions(
                noncurrentVersionTransitions?.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .prefix(prefix?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .transitions(
                transitions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [BucketV2LifecycleRuleArgs].
 */
@PulumiTagMarker
public class BucketV2LifecycleRuleArgsBuilder internal constructor() {
    private var abortIncompleteMultipartUploadDays: Output<Int>? = null

    private var enabled: Output<Boolean>? = null

    private var expirations: Output<List<BucketV2LifecycleRuleExpirationArgs>>? = null

    private var id: Output<String>? = null

    private var noncurrentVersionExpirations:
        Output<List<BucketV2LifecycleRuleNoncurrentVersionExpirationArgs>>? = null

    private var noncurrentVersionTransitions:
        Output<List<BucketV2LifecycleRuleNoncurrentVersionTransitionArgs>>? = null

    private var prefix: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var transitions: Output<List<BucketV2LifecycleRuleTransitionArgs>>? = null

    /**
     * @param value Specifies the number of days after initiating a multipart upload when the multipart upload must be completed.
     */
    @JvmName("tiditgghoqiivdfm")
    public suspend fun abortIncompleteMultipartUploadDays(`value`: Output<Int>) {
        this.abortIncompleteMultipartUploadDays = value
    }

    /**
     * @param value Specifies lifecycle rule status.
     */
    @JvmName("fxcocyhtyboxotpx")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Specifies a period in the object's expire. See Expiration below for details.
     */
    @JvmName("eakdtnmsumkrempt")
    public suspend fun expirations(`value`: Output<List<BucketV2LifecycleRuleExpirationArgs>>) {
        this.expirations = value
    }

    @JvmName("gumemfkdkxhnmapp")
    public suspend fun expirations(vararg values: Output<BucketV2LifecycleRuleExpirationArgs>) {
        this.expirations = Output.all(values.asList())
    }

    /**
     * @param values Specifies a period in the object's expire. See Expiration below for details.
     */
    @JvmName("yrbenewrudmhhruj")
    public suspend fun expirations(values: List<Output<BucketV2LifecycleRuleExpirationArgs>>) {
        this.expirations = Output.all(values)
    }

    /**
     * @param value Unique identifier for the rule. Must be less than or equal to 255 characters in length.
     */
    @JvmName("sldccqhqrbxqpaly")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Specifies when noncurrent object versions expire. See Noncurrent Version Expiration below for details.
     */
    @JvmName("gtogmtdjfrypfldf")
    public suspend
    fun noncurrentVersionExpirations(`value`: Output<List<BucketV2LifecycleRuleNoncurrentVersionExpirationArgs>>) {
        this.noncurrentVersionExpirations = value
    }

    @JvmName("hagfrnpbpfkbnfdh")
    public suspend fun noncurrentVersionExpirations(
        vararg
        values: Output<BucketV2LifecycleRuleNoncurrentVersionExpirationArgs>,
    ) {
        this.noncurrentVersionExpirations = Output.all(values.asList())
    }

    /**
     * @param values Specifies when noncurrent object versions expire. See Noncurrent Version Expiration below for details.
     */
    @JvmName("vcphysmitrutxhvq")
    public suspend
    fun noncurrentVersionExpirations(values: List<Output<BucketV2LifecycleRuleNoncurrentVersionExpirationArgs>>) {
        this.noncurrentVersionExpirations = Output.all(values)
    }

    /**
     * @param value Specifies when noncurrent object versions transitions. See Noncurrent Version Transition below for details.
     */
    @JvmName("nryvmtcmoaowtqws")
    public suspend
    fun noncurrentVersionTransitions(`value`: Output<List<BucketV2LifecycleRuleNoncurrentVersionTransitionArgs>>) {
        this.noncurrentVersionTransitions = value
    }

    @JvmName("twajdgypwgwrrlpm")
    public suspend fun noncurrentVersionTransitions(
        vararg
        values: Output<BucketV2LifecycleRuleNoncurrentVersionTransitionArgs>,
    ) {
        this.noncurrentVersionTransitions = Output.all(values.asList())
    }

    /**
     * @param values Specifies when noncurrent object versions transitions. See Noncurrent Version Transition below for details.
     */
    @JvmName("awlkffpvuvvnibew")
    public suspend
    fun noncurrentVersionTransitions(values: List<Output<BucketV2LifecycleRuleNoncurrentVersionTransitionArgs>>) {
        this.noncurrentVersionTransitions = Output.all(values)
    }

    /**
     * @param value Object key prefix identifying one or more objects to which the rule applies.
     */
    @JvmName("glmpohibqwaiommi")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value Specifies object tags key and value.
     */
    @JvmName("tbtxkeunkvoqdpdt")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies a period in the object's transitions. See Transition below for details.
     */
    @JvmName("nvbbllurqlwbglpd")
    public suspend fun transitions(`value`: Output<List<BucketV2LifecycleRuleTransitionArgs>>) {
        this.transitions = value
    }

    @JvmName("tdcbhxgpwenitcqn")
    public suspend fun transitions(vararg values: Output<BucketV2LifecycleRuleTransitionArgs>) {
        this.transitions = Output.all(values.asList())
    }

    /**
     * @param values Specifies a period in the object's transitions. See Transition below for details.
     */
    @JvmName("lpvairdnkdjabwpe")
    public suspend fun transitions(values: List<Output<BucketV2LifecycleRuleTransitionArgs>>) {
        this.transitions = Output.all(values)
    }

    /**
     * @param value Specifies the number of days after initiating a multipart upload when the multipart upload must be completed.
     */
    @JvmName("ybrohwtnmduejufw")
    public suspend fun abortIncompleteMultipartUploadDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.abortIncompleteMultipartUploadDays = mapped
    }

    /**
     * @param value Specifies lifecycle rule status.
     */
    @JvmName("vqhucloinnnibjjm")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Specifies a period in the object's expire. See Expiration below for details.
     */
    @JvmName("lkmnpyqqnrgeqswv")
    public suspend fun expirations(`value`: List<BucketV2LifecycleRuleExpirationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expirations = mapped
    }

    /**
     * @param argument Specifies a period in the object's expire. See Expiration below for details.
     */
    @JvmName("jwwfioqfiojqoqxc")
    public suspend
    fun expirations(argument: List<suspend BucketV2LifecycleRuleExpirationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BucketV2LifecycleRuleExpirationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.expirations = mapped
    }

    /**
     * @param argument Specifies a period in the object's expire. See Expiration below for details.
     */
    @JvmName("jrsafddempjqnvho")
    public suspend fun expirations(
        vararg
        argument: suspend BucketV2LifecycleRuleExpirationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            BucketV2LifecycleRuleExpirationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.expirations = mapped
    }

    /**
     * @param argument Specifies a period in the object's expire. See Expiration below for details.
     */
    @JvmName("waflnmjilpiiyfmv")
    public suspend
    fun expirations(argument: suspend BucketV2LifecycleRuleExpirationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            BucketV2LifecycleRuleExpirationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.expirations = mapped
    }

    /**
     * @param values Specifies a period in the object's expire. See Expiration below for details.
     */
    @JvmName("lknhlntedbwkxhwt")
    public suspend fun expirations(vararg values: BucketV2LifecycleRuleExpirationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.expirations = mapped
    }

    /**
     * @param value Unique identifier for the rule. Must be less than or equal to 255 characters in length.
     */
    @JvmName("sjjicybikorykaha")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Specifies when noncurrent object versions expire. See Noncurrent Version Expiration below for details.
     */
    @JvmName("pgoktxtaglylvhml")
    public suspend
    fun noncurrentVersionExpirations(`value`: List<BucketV2LifecycleRuleNoncurrentVersionExpirationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.noncurrentVersionExpirations = mapped
    }

    /**
     * @param argument Specifies when noncurrent object versions expire. See Noncurrent Version Expiration below for details.
     */
    @JvmName("yshvpljprjyaddkl")
    public suspend
    fun noncurrentVersionExpirations(argument: List<suspend BucketV2LifecycleRuleNoncurrentVersionExpirationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BucketV2LifecycleRuleNoncurrentVersionExpirationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.noncurrentVersionExpirations = mapped
    }

    /**
     * @param argument Specifies when noncurrent object versions expire. See Noncurrent Version Expiration below for details.
     */
    @JvmName("lrvqkxvxcbktavxc")
    public suspend fun noncurrentVersionExpirations(
        vararg
        argument: suspend BucketV2LifecycleRuleNoncurrentVersionExpirationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            BucketV2LifecycleRuleNoncurrentVersionExpirationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.noncurrentVersionExpirations = mapped
    }

    /**
     * @param argument Specifies when noncurrent object versions expire. See Noncurrent Version Expiration below for details.
     */
    @JvmName("fubjeafkbamidujo")
    public suspend
    fun noncurrentVersionExpirations(argument: suspend BucketV2LifecycleRuleNoncurrentVersionExpirationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                BucketV2LifecycleRuleNoncurrentVersionExpirationArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.noncurrentVersionExpirations = mapped
    }

    /**
     * @param values Specifies when noncurrent object versions expire. See Noncurrent Version Expiration below for details.
     */
    @JvmName("kpiispqilxitxmnf")
    public suspend fun noncurrentVersionExpirations(
        vararg
        values: BucketV2LifecycleRuleNoncurrentVersionExpirationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.noncurrentVersionExpirations = mapped
    }

    /**
     * @param value Specifies when noncurrent object versions transitions. See Noncurrent Version Transition below for details.
     */
    @JvmName("edplxfamoadcnshy")
    public suspend
    fun noncurrentVersionTransitions(`value`: List<BucketV2LifecycleRuleNoncurrentVersionTransitionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.noncurrentVersionTransitions = mapped
    }

    /**
     * @param argument Specifies when noncurrent object versions transitions. See Noncurrent Version Transition below for details.
     */
    @JvmName("puujlkhyfbbxmirp")
    public suspend
    fun noncurrentVersionTransitions(argument: List<suspend BucketV2LifecycleRuleNoncurrentVersionTransitionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BucketV2LifecycleRuleNoncurrentVersionTransitionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.noncurrentVersionTransitions = mapped
    }

    /**
     * @param argument Specifies when noncurrent object versions transitions. See Noncurrent Version Transition below for details.
     */
    @JvmName("mhgiqmgucgffbbty")
    public suspend fun noncurrentVersionTransitions(
        vararg
        argument: suspend BucketV2LifecycleRuleNoncurrentVersionTransitionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            BucketV2LifecycleRuleNoncurrentVersionTransitionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.noncurrentVersionTransitions = mapped
    }

    /**
     * @param argument Specifies when noncurrent object versions transitions. See Noncurrent Version Transition below for details.
     */
    @JvmName("fpvydbytnrbmequb")
    public suspend
    fun noncurrentVersionTransitions(argument: suspend BucketV2LifecycleRuleNoncurrentVersionTransitionArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                BucketV2LifecycleRuleNoncurrentVersionTransitionArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.noncurrentVersionTransitions = mapped
    }

    /**
     * @param values Specifies when noncurrent object versions transitions. See Noncurrent Version Transition below for details.
     */
    @JvmName("fcivswjwltbxjwqe")
    public suspend fun noncurrentVersionTransitions(
        vararg
        values: BucketV2LifecycleRuleNoncurrentVersionTransitionArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.noncurrentVersionTransitions = mapped
    }

    /**
     * @param value Object key prefix identifying one or more objects to which the rule applies.
     */
    @JvmName("tqujdbygyhoilbcc")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    /**
     * @param value Specifies object tags key and value.
     */
    @JvmName("ahgaqnlpknapfrmk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Specifies object tags key and value.
     */
    @JvmName("rvhimxftwuvlsuoj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Specifies a period in the object's transitions. See Transition below for details.
     */
    @JvmName("clfidrooedtxnhnt")
    public suspend fun transitions(`value`: List<BucketV2LifecycleRuleTransitionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitions = mapped
    }

    /**
     * @param argument Specifies a period in the object's transitions. See Transition below for details.
     */
    @JvmName("rwrqkgxtjhhgecuw")
    public suspend
    fun transitions(argument: List<suspend BucketV2LifecycleRuleTransitionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BucketV2LifecycleRuleTransitionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.transitions = mapped
    }

    /**
     * @param argument Specifies a period in the object's transitions. See Transition below for details.
     */
    @JvmName("nhsxeirlphlafnek")
    public suspend fun transitions(
        vararg
        argument: suspend BucketV2LifecycleRuleTransitionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            BucketV2LifecycleRuleTransitionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.transitions = mapped
    }

    /**
     * @param argument Specifies a period in the object's transitions. See Transition below for details.
     */
    @JvmName("vmvjvvsrlydugugt")
    public suspend
    fun transitions(argument: suspend BucketV2LifecycleRuleTransitionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            BucketV2LifecycleRuleTransitionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.transitions = mapped
    }

    /**
     * @param values Specifies a period in the object's transitions. See Transition below for details.
     */
    @JvmName("gfqvijoxygdgleuu")
    public suspend fun transitions(vararg values: BucketV2LifecycleRuleTransitionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.transitions = mapped
    }

    internal fun build(): BucketV2LifecycleRuleArgs = BucketV2LifecycleRuleArgs(
        abortIncompleteMultipartUploadDays = abortIncompleteMultipartUploadDays,
        enabled = enabled ?: throw PulumiNullFieldException("enabled"),
        expirations = expirations,
        id = id,
        noncurrentVersionExpirations = noncurrentVersionExpirations,
        noncurrentVersionTransitions = noncurrentVersionTransitions,
        prefix = prefix,
        tags = tags,
        transitions = transitions,
    )
}
