@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketV2LifecycleRuleExpirationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property date Specifies the date after which you want the corresponding action to take effect.
 * @property days Specifies the number of days after object creation when the specific rule action takes effect.
 * @property expiredObjectDeleteMarker On a versioned bucket (versioning-enabled or versioning-suspended bucket), you can add this element in the lifecycle configuration to direct Amazon S3 to delete expired object delete markers. This cannot be specified with Days or Date in a Lifecycle Expiration Policy.
 */
public data class BucketV2LifecycleRuleExpirationArgs(
    public val date: Output<String>? = null,
    public val days: Output<Int>? = null,
    public val expiredObjectDeleteMarker: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketV2LifecycleRuleExpirationArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketV2LifecycleRuleExpirationArgs =
        com.pulumi.aws.s3.inputs.BucketV2LifecycleRuleExpirationArgs.builder()
            .date(date?.applyValue({ args0 -> args0 }))
            .days(days?.applyValue({ args0 -> args0 }))
            .expiredObjectDeleteMarker(expiredObjectDeleteMarker?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketV2LifecycleRuleExpirationArgs].
 */
@PulumiTagMarker
public class BucketV2LifecycleRuleExpirationArgsBuilder internal constructor() {
    private var date: Output<String>? = null

    private var days: Output<Int>? = null

    private var expiredObjectDeleteMarker: Output<Boolean>? = null

    /**
     * @param value Specifies the date after which you want the corresponding action to take effect.
     */
    @JvmName("xkgxubtowdpixsjf")
    public suspend fun date(`value`: Output<String>) {
        this.date = value
    }

    /**
     * @param value Specifies the number of days after object creation when the specific rule action takes effect.
     */
    @JvmName("fwyhhttpfwylkivi")
    public suspend fun days(`value`: Output<Int>) {
        this.days = value
    }

    /**
     * @param value On a versioned bucket (versioning-enabled or versioning-suspended bucket), you can add this element in the lifecycle configuration to direct Amazon S3 to delete expired object delete markers. This cannot be specified with Days or Date in a Lifecycle Expiration Policy.
     */
    @JvmName("gnqmafgbynvvwfmj")
    public suspend fun expiredObjectDeleteMarker(`value`: Output<Boolean>) {
        this.expiredObjectDeleteMarker = value
    }

    /**
     * @param value Specifies the date after which you want the corresponding action to take effect.
     */
    @JvmName("hsiubnwgfaactyyg")
    public suspend fun date(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.date = mapped
    }

    /**
     * @param value Specifies the number of days after object creation when the specific rule action takes effect.
     */
    @JvmName("wcugfbkexxrebsjf")
    public suspend fun days(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.days = mapped
    }

    /**
     * @param value On a versioned bucket (versioning-enabled or versioning-suspended bucket), you can add this element in the lifecycle configuration to direct Amazon S3 to delete expired object delete markers. This cannot be specified with Days or Date in a Lifecycle Expiration Policy.
     */
    @JvmName("maqfplabeexuysla")
    public suspend fun expiredObjectDeleteMarker(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expiredObjectDeleteMarker = mapped
    }

    internal fun build(): BucketV2LifecycleRuleExpirationArgs = BucketV2LifecycleRuleExpirationArgs(
        date = date,
        days = days,
        expiredObjectDeleteMarker = expiredObjectDeleteMarker,
    )
}
