@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketV2LifecycleRuleNoncurrentVersionExpirationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property days Specifies the number of days noncurrent object versions expire.
 */
public data class BucketV2LifecycleRuleNoncurrentVersionExpirationArgs(
    public val days: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketV2LifecycleRuleNoncurrentVersionExpirationArgs> {
    override fun toJava():
        com.pulumi.aws.s3.inputs.BucketV2LifecycleRuleNoncurrentVersionExpirationArgs =
        com.pulumi.aws.s3.inputs.BucketV2LifecycleRuleNoncurrentVersionExpirationArgs.builder()
            .days(days?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketV2LifecycleRuleNoncurrentVersionExpirationArgs].
 */
@PulumiTagMarker
public class BucketV2LifecycleRuleNoncurrentVersionExpirationArgsBuilder internal constructor() {
    private var days: Output<Int>? = null

    /**
     * @param value Specifies the number of days noncurrent object versions expire.
     */
    @JvmName("tljnevqrpetaronn")
    public suspend fun days(`value`: Output<Int>) {
        this.days = value
    }

    /**
     * @param value Specifies the number of days noncurrent object versions expire.
     */
    @JvmName("nyhmwxscbosirfhh")
    public suspend fun days(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.days = mapped
    }

    internal fun build(): BucketV2LifecycleRuleNoncurrentVersionExpirationArgs =
        BucketV2LifecycleRuleNoncurrentVersionExpirationArgs(
            days = days,
        )
}
