@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketV2LifecycleRuleNoncurrentVersionTransitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property days Specifies the number of days noncurrent object versions transition.
 * @property storageClass Specifies the Amazon S3 [storage class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_Transition.html#AmazonS3-Type-Transition-StorageClass) to which you want the object to transition.
 */
public data class BucketV2LifecycleRuleNoncurrentVersionTransitionArgs(
    public val days: Output<Int>? = null,
    public val storageClass: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketV2LifecycleRuleNoncurrentVersionTransitionArgs> {
    override fun toJava():
        com.pulumi.aws.s3.inputs.BucketV2LifecycleRuleNoncurrentVersionTransitionArgs =
        com.pulumi.aws.s3.inputs.BucketV2LifecycleRuleNoncurrentVersionTransitionArgs.builder()
            .days(days?.applyValue({ args0 -> args0 }))
            .storageClass(storageClass.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketV2LifecycleRuleNoncurrentVersionTransitionArgs].
 */
@PulumiTagMarker
public class BucketV2LifecycleRuleNoncurrentVersionTransitionArgsBuilder internal constructor() {
    private var days: Output<Int>? = null

    private var storageClass: Output<String>? = null

    /**
     * @param value Specifies the number of days noncurrent object versions transition.
     */
    @JvmName("yexngcqpkdmggokv")
    public suspend fun days(`value`: Output<Int>) {
        this.days = value
    }

    /**
     * @param value Specifies the Amazon S3 [storage class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_Transition.html#AmazonS3-Type-Transition-StorageClass) to which you want the object to transition.
     */
    @JvmName("ebgahuuxeieyxqul")
    public suspend fun storageClass(`value`: Output<String>) {
        this.storageClass = value
    }

    /**
     * @param value Specifies the number of days noncurrent object versions transition.
     */
    @JvmName("nndrysgvoopwolwm")
    public suspend fun days(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.days = mapped
    }

    /**
     * @param value Specifies the Amazon S3 [storage class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_Transition.html#AmazonS3-Type-Transition-StorageClass) to which you want the object to transition.
     */
    @JvmName("upijfwrgukohukpn")
    public suspend fun storageClass(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageClass = mapped
    }

    internal fun build(): BucketV2LifecycleRuleNoncurrentVersionTransitionArgs =
        BucketV2LifecycleRuleNoncurrentVersionTransitionArgs(
            days = days,
            storageClass = storageClass ?: throw PulumiNullFieldException("storageClass"),
        )
}
