@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketV2ObjectLockConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property objectLockEnabled Indicates whether this bucket has an Object Lock configuration enabled. Valid values are `true` or `false`. This argument is not supported in all regions or partitions.
 * @property rules Object Lock rule in place for this bucket (documented below).
 */
public data class BucketV2ObjectLockConfigurationArgs(
    @Deprecated(
        message = """
  Use the top-level parameter object_lock_enabled instead
  """,
    )
    public val objectLockEnabled: Output<String>? = null,
    @Deprecated(
        message = """
  Use the aws_s3_bucket_object_lock_configuration resource instead
  """,
    )
    public val rules: Output<List<BucketV2ObjectLockConfigurationRuleArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketV2ObjectLockConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketV2ObjectLockConfigurationArgs =
        com.pulumi.aws.s3.inputs.BucketV2ObjectLockConfigurationArgs.builder()
            .objectLockEnabled(objectLockEnabled?.applyValue({ args0 -> args0 }))
            .rules(
                rules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [BucketV2ObjectLockConfigurationArgs].
 */
@PulumiTagMarker
public class BucketV2ObjectLockConfigurationArgsBuilder internal constructor() {
    private var objectLockEnabled: Output<String>? = null

    private var rules: Output<List<BucketV2ObjectLockConfigurationRuleArgs>>? = null

    /**
     * @param value Indicates whether this bucket has an Object Lock configuration enabled. Valid values are `true` or `false`. This argument is not supported in all regions or partitions.
     */
    @Deprecated(
        message = """
  Use the top-level parameter object_lock_enabled instead
  """,
    )
    @JvmName("jgprxsoespetwtvn")
    public suspend fun objectLockEnabled(`value`: Output<String>) {
        this.objectLockEnabled = value
    }

    /**
     * @param value Object Lock rule in place for this bucket (documented below).
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_object_lock_configuration resource instead
  """,
    )
    @JvmName("dckddkubmiqxubug")
    public suspend fun rules(`value`: Output<List<BucketV2ObjectLockConfigurationRuleArgs>>) {
        this.rules = value
    }

    @JvmName("punurvsngfuhqvmq")
    public suspend fun rules(vararg values: Output<BucketV2ObjectLockConfigurationRuleArgs>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values Object Lock rule in place for this bucket (documented below).
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_object_lock_configuration resource instead
  """,
    )
    @JvmName("tunwdadrchdjdjew")
    public suspend fun rules(values: List<Output<BucketV2ObjectLockConfigurationRuleArgs>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value Indicates whether this bucket has an Object Lock configuration enabled. Valid values are `true` or `false`. This argument is not supported in all regions or partitions.
     */
    @Deprecated(
        message = """
  Use the top-level parameter object_lock_enabled instead
  """,
    )
    @JvmName("fhiegdonfiiaxxaw")
    public suspend fun objectLockEnabled(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.objectLockEnabled = mapped
    }

    /**
     * @param value Object Lock rule in place for this bucket (documented below).
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_object_lock_configuration resource instead
  """,
    )
    @JvmName("gqhgkoebtpgcwjnj")
    public suspend fun rules(`value`: List<BucketV2ObjectLockConfigurationRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param argument Object Lock rule in place for this bucket (documented below).
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_object_lock_configuration resource instead
  """,
    )
    @JvmName("cndhevvkcnrriafe")
    public suspend
    fun rules(argument: List<suspend BucketV2ObjectLockConfigurationRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BucketV2ObjectLockConfigurationRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument Object Lock rule in place for this bucket (documented below).
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_object_lock_configuration resource instead
  """,
    )
    @JvmName("oxxflonsrtlrwfpx")
    public suspend fun rules(
        vararg
        argument: suspend BucketV2ObjectLockConfigurationRuleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            BucketV2ObjectLockConfigurationRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument Object Lock rule in place for this bucket (documented below).
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_object_lock_configuration resource instead
  """,
    )
    @JvmName("aprdupjptsgksogv")
    public suspend
    fun rules(argument: suspend BucketV2ObjectLockConfigurationRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            BucketV2ObjectLockConfigurationRuleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param values Object Lock rule in place for this bucket (documented below).
     */
    @Deprecated(
        message = """
  Use the aws_s3_bucket_object_lock_configuration resource instead
  """,
    )
    @JvmName("piserbgtohpyqvln")
    public suspend fun rules(vararg values: BucketV2ObjectLockConfigurationRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    internal fun build(): BucketV2ObjectLockConfigurationArgs = BucketV2ObjectLockConfigurationArgs(
        objectLockEnabled = objectLockEnabled,
        rules = rules,
    )
}
