@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketV2ObjectLockConfigurationRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property defaultRetentions Default retention period that you want to apply to new objects placed in this bucket (documented below).
 */
public data class BucketV2ObjectLockConfigurationRuleArgs(
    public val defaultRetentions:
    Output<List<BucketV2ObjectLockConfigurationRuleDefaultRetentionArgs>>,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketV2ObjectLockConfigurationRuleArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketV2ObjectLockConfigurationRuleArgs =
        com.pulumi.aws.s3.inputs.BucketV2ObjectLockConfigurationRuleArgs.builder()
            .defaultRetentions(
                defaultRetentions.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [BucketV2ObjectLockConfigurationRuleArgs].
 */
@PulumiTagMarker
public class BucketV2ObjectLockConfigurationRuleArgsBuilder internal constructor() {
    private var defaultRetentions:
        Output<List<BucketV2ObjectLockConfigurationRuleDefaultRetentionArgs>>? = null

    /**
     * @param value Default retention period that you want to apply to new objects placed in this bucket (documented below).
     */
    @JvmName("utwqsakbodwvewoa")
    public suspend
    fun defaultRetentions(`value`: Output<List<BucketV2ObjectLockConfigurationRuleDefaultRetentionArgs>>) {
        this.defaultRetentions = value
    }

    @JvmName("ghhjhglcmtwuebnx")
    public suspend fun defaultRetentions(
        vararg
        values: Output<BucketV2ObjectLockConfigurationRuleDefaultRetentionArgs>,
    ) {
        this.defaultRetentions = Output.all(values.asList())
    }

    /**
     * @param values Default retention period that you want to apply to new objects placed in this bucket (documented below).
     */
    @JvmName("fiqytyjukylowjhi")
    public suspend
    fun defaultRetentions(values: List<Output<BucketV2ObjectLockConfigurationRuleDefaultRetentionArgs>>) {
        this.defaultRetentions = Output.all(values)
    }

    /**
     * @param value Default retention period that you want to apply to new objects placed in this bucket (documented below).
     */
    @JvmName("imsjhbyqlkctpbss")
    public suspend
    fun defaultRetentions(`value`: List<BucketV2ObjectLockConfigurationRuleDefaultRetentionArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultRetentions = mapped
    }

    /**
     * @param argument Default retention period that you want to apply to new objects placed in this bucket (documented below).
     */
    @JvmName("hwidaaxxqjbwbuam")
    public suspend
    fun defaultRetentions(argument: List<suspend BucketV2ObjectLockConfigurationRuleDefaultRetentionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BucketV2ObjectLockConfigurationRuleDefaultRetentionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.defaultRetentions = mapped
    }

    /**
     * @param argument Default retention period that you want to apply to new objects placed in this bucket (documented below).
     */
    @JvmName("blcsshbsqfxinyox")
    public suspend fun defaultRetentions(
        vararg
        argument: suspend BucketV2ObjectLockConfigurationRuleDefaultRetentionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            BucketV2ObjectLockConfigurationRuleDefaultRetentionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.defaultRetentions = mapped
    }

    /**
     * @param argument Default retention period that you want to apply to new objects placed in this bucket (documented below).
     */
    @JvmName("pkdrnftcutneiscr")
    public suspend
    fun defaultRetentions(argument: suspend BucketV2ObjectLockConfigurationRuleDefaultRetentionArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                BucketV2ObjectLockConfigurationRuleDefaultRetentionArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.defaultRetentions = mapped
    }

    /**
     * @param values Default retention period that you want to apply to new objects placed in this bucket (documented below).
     */
    @JvmName("pwypjbjfdlqggqju")
    public suspend fun defaultRetentions(
        vararg
        values: BucketV2ObjectLockConfigurationRuleDefaultRetentionArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultRetentions = mapped
    }

    internal fun build(): BucketV2ObjectLockConfigurationRuleArgs =
        BucketV2ObjectLockConfigurationRuleArgs(
            defaultRetentions = defaultRetentions ?: throw PulumiNullFieldException("defaultRetentions"),
        )
}
