@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketV2ReplicationConfigurationRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property deleteMarkerReplicationStatus Whether delete markers are replicated. The only valid value is `Enabled`. To disable, omit this argument. This argument is only valid with V2 replication configurations (i.e., when `filter` is used).
 * @property destinations Specifies the destination for the rule (documented below).
 * @property filters Filter that identifies subset of objects to which the replication rule applies (documented below).
 * @property id Unique identifier for the rule. Must be less than or equal to 255 characters in length.
 * @property prefix Object keyname prefix identifying one or more objects to which the rule applies. Must be less than or equal to 1024 characters in length.
 * @property priority Priority associated with the rule. Priority should only be set if `filter` is configured. If not provided, defaults to `0`. Priority must be unique between multiple rules.
 * @property sourceSelectionCriterias Specifies special object selection criteria (documented below).
 * @property status Status of the rule. Either `Enabled` or `Disabled`. The rule is ignored if status is not Enabled.
 */
public data class BucketV2ReplicationConfigurationRuleArgs(
    public val deleteMarkerReplicationStatus: Output<String>? = null,
    public val destinations: Output<List<BucketV2ReplicationConfigurationRuleDestinationArgs>>,
    public val filters: Output<List<BucketV2ReplicationConfigurationRuleFilterArgs>>? = null,
    public val id: Output<String>? = null,
    public val prefix: Output<String>? = null,
    public val priority: Output<Int>? = null,
    public val sourceSelectionCriterias:
    Output<List<BucketV2ReplicationConfigurationRuleSourceSelectionCriteriaArgs>>? = null,
    public val status: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketV2ReplicationConfigurationRuleArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketV2ReplicationConfigurationRuleArgs =
        com.pulumi.aws.s3.inputs.BucketV2ReplicationConfigurationRuleArgs.builder()
            .deleteMarkerReplicationStatus(deleteMarkerReplicationStatus?.applyValue({ args0 -> args0 }))
            .destinations(
                destinations.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .filters(
                filters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .id(id?.applyValue({ args0 -> args0 }))
            .prefix(prefix?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .sourceSelectionCriterias(
                sourceSelectionCriterias?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .status(status.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketV2ReplicationConfigurationRuleArgs].
 */
@PulumiTagMarker
public class BucketV2ReplicationConfigurationRuleArgsBuilder internal constructor() {
    private var deleteMarkerReplicationStatus: Output<String>? = null

    private var destinations: Output<List<BucketV2ReplicationConfigurationRuleDestinationArgs>>? =
        null

    private var filters: Output<List<BucketV2ReplicationConfigurationRuleFilterArgs>>? = null

    private var id: Output<String>? = null

    private var prefix: Output<String>? = null

    private var priority: Output<Int>? = null

    private var sourceSelectionCriterias:
        Output<List<BucketV2ReplicationConfigurationRuleSourceSelectionCriteriaArgs>>? = null

    private var status: Output<String>? = null

    /**
     * @param value Whether delete markers are replicated. The only valid value is `Enabled`. To disable, omit this argument. This argument is only valid with V2 replication configurations (i.e., when `filter` is used).
     */
    @JvmName("omhxprqksbipaqxn")
    public suspend fun deleteMarkerReplicationStatus(`value`: Output<String>) {
        this.deleteMarkerReplicationStatus = value
    }

    /**
     * @param value Specifies the destination for the rule (documented below).
     */
    @JvmName("avjihsyhtbgycdbt")
    public suspend
    fun destinations(`value`: Output<List<BucketV2ReplicationConfigurationRuleDestinationArgs>>) {
        this.destinations = value
    }

    @JvmName("txjnxhocxxspbqax")
    public suspend fun destinations(
        vararg
        values: Output<BucketV2ReplicationConfigurationRuleDestinationArgs>,
    ) {
        this.destinations = Output.all(values.asList())
    }

    /**
     * @param values Specifies the destination for the rule (documented below).
     */
    @JvmName("hmiqsgyehyjxeskn")
    public suspend
    fun destinations(values: List<Output<BucketV2ReplicationConfigurationRuleDestinationArgs>>) {
        this.destinations = Output.all(values)
    }

    /**
     * @param value Filter that identifies subset of objects to which the replication rule applies (documented below).
     */
    @JvmName("kfvftshtyvuxxyyg")
    public suspend
    fun filters(`value`: Output<List<BucketV2ReplicationConfigurationRuleFilterArgs>>) {
        this.filters = value
    }

    @JvmName("qacmgvakraqsnuhe")
    public suspend fun filters(
        vararg
        values: Output<BucketV2ReplicationConfigurationRuleFilterArgs>,
    ) {
        this.filters = Output.all(values.asList())
    }

    /**
     * @param values Filter that identifies subset of objects to which the replication rule applies (documented below).
     */
    @JvmName("browxbmkobenfnyk")
    public suspend fun filters(values: List<Output<BucketV2ReplicationConfigurationRuleFilterArgs>>) {
        this.filters = Output.all(values)
    }

    /**
     * @param value Unique identifier for the rule. Must be less than or equal to 255 characters in length.
     */
    @JvmName("cliswemtpfdnnrvn")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Object keyname prefix identifying one or more objects to which the rule applies. Must be less than or equal to 1024 characters in length.
     */
    @JvmName("rgabphbfikqwdnkm")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value Priority associated with the rule. Priority should only be set if `filter` is configured. If not provided, defaults to `0`. Priority must be unique between multiple rules.
     */
    @JvmName("ppnktoofrynvsjqt")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value Specifies special object selection criteria (documented below).
     */
    @JvmName("wndjglxbptaexdin")
    public suspend
    fun sourceSelectionCriterias(`value`: Output<List<BucketV2ReplicationConfigurationRuleSourceSelectionCriteriaArgs>>) {
        this.sourceSelectionCriterias = value
    }

    @JvmName("kgmmrshoyjdmxcvl")
    public suspend fun sourceSelectionCriterias(
        vararg
        values: Output<BucketV2ReplicationConfigurationRuleSourceSelectionCriteriaArgs>,
    ) {
        this.sourceSelectionCriterias = Output.all(values.asList())
    }

    /**
     * @param values Specifies special object selection criteria (documented below).
     */
    @JvmName("fxhvumrqvxljatfv")
    public suspend
    fun sourceSelectionCriterias(values: List<Output<BucketV2ReplicationConfigurationRuleSourceSelectionCriteriaArgs>>) {
        this.sourceSelectionCriterias = Output.all(values)
    }

    /**
     * @param value Status of the rule. Either `Enabled` or `Disabled`. The rule is ignored if status is not Enabled.
     */
    @JvmName("iqaptayqishamvmb")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Whether delete markers are replicated. The only valid value is `Enabled`. To disable, omit this argument. This argument is only valid with V2 replication configurations (i.e., when `filter` is used).
     */
    @JvmName("ddcaxujyyxgbyqwh")
    public suspend fun deleteMarkerReplicationStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteMarkerReplicationStatus = mapped
    }

    /**
     * @param value Specifies the destination for the rule (documented below).
     */
    @JvmName("ggntaoxywdbrmqsq")
    public suspend
    fun destinations(`value`: List<BucketV2ReplicationConfigurationRuleDestinationArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinations = mapped
    }

    /**
     * @param argument Specifies the destination for the rule (documented below).
     */
    @JvmName("bobiaaupxoxvjcyv")
    public suspend
    fun destinations(argument: List<suspend BucketV2ReplicationConfigurationRuleDestinationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BucketV2ReplicationConfigurationRuleDestinationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.destinations = mapped
    }

    /**
     * @param argument Specifies the destination for the rule (documented below).
     */
    @JvmName("uumkdsicmmjnnqfp")
    public suspend fun destinations(
        vararg
        argument: suspend BucketV2ReplicationConfigurationRuleDestinationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            BucketV2ReplicationConfigurationRuleDestinationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.destinations = mapped
    }

    /**
     * @param argument Specifies the destination for the rule (documented below).
     */
    @JvmName("xiyeimgyxeqjtjuw")
    public suspend
    fun destinations(argument: suspend BucketV2ReplicationConfigurationRuleDestinationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                BucketV2ReplicationConfigurationRuleDestinationArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.destinations = mapped
    }

    /**
     * @param values Specifies the destination for the rule (documented below).
     */
    @JvmName("wtnklpsumdnqgopj")
    public suspend fun destinations(
        vararg
        values: BucketV2ReplicationConfigurationRuleDestinationArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinations = mapped
    }

    /**
     * @param value Filter that identifies subset of objects to which the replication rule applies (documented below).
     */
    @JvmName("iwxlmqtydldnjrnp")
    public suspend fun filters(`value`: List<BucketV2ReplicationConfigurationRuleFilterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filters = mapped
    }

    /**
     * @param argument Filter that identifies subset of objects to which the replication rule applies (documented below).
     */
    @JvmName("fvkvpuxkqibfiehq")
    public suspend
    fun filters(argument: List<suspend BucketV2ReplicationConfigurationRuleFilterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BucketV2ReplicationConfigurationRuleFilterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.filters = mapped
    }

    /**
     * @param argument Filter that identifies subset of objects to which the replication rule applies (documented below).
     */
    @JvmName("bsievhubxgjnrjdo")
    public suspend fun filters(
        vararg
        argument: suspend BucketV2ReplicationConfigurationRuleFilterArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            BucketV2ReplicationConfigurationRuleFilterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.filters = mapped
    }

    /**
     * @param argument Filter that identifies subset of objects to which the replication rule applies (documented below).
     */
    @JvmName("eugvcuhicbhmqstf")
    public suspend
    fun filters(argument: suspend BucketV2ReplicationConfigurationRuleFilterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            BucketV2ReplicationConfigurationRuleFilterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.filters = mapped
    }

    /**
     * @param values Filter that identifies subset of objects to which the replication rule applies (documented below).
     */
    @JvmName("sbmbuqnpnsqquarb")
    public suspend fun filters(vararg values: BucketV2ReplicationConfigurationRuleFilterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filters = mapped
    }

    /**
     * @param value Unique identifier for the rule. Must be less than or equal to 255 characters in length.
     */
    @JvmName("ixopcesxivfdhfpl")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Object keyname prefix identifying one or more objects to which the rule applies. Must be less than or equal to 1024 characters in length.
     */
    @JvmName("kbixwbrrdnjhchmu")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    /**
     * @param value Priority associated with the rule. Priority should only be set if `filter` is configured. If not provided, defaults to `0`. Priority must be unique between multiple rules.
     */
    @JvmName("txyqydrqxxcxnvst")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value Specifies special object selection criteria (documented below).
     */
    @JvmName("rgmqsgshvstjictf")
    public suspend
    fun sourceSelectionCriterias(`value`: List<BucketV2ReplicationConfigurationRuleSourceSelectionCriteriaArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceSelectionCriterias = mapped
    }

    /**
     * @param argument Specifies special object selection criteria (documented below).
     */
    @JvmName("cbsgtalxjubuckdq")
    public suspend
    fun sourceSelectionCriterias(argument: List<suspend BucketV2ReplicationConfigurationRuleSourceSelectionCriteriaArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BucketV2ReplicationConfigurationRuleSourceSelectionCriteriaArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sourceSelectionCriterias = mapped
    }

    /**
     * @param argument Specifies special object selection criteria (documented below).
     */
    @JvmName("tiqkstxtifhtyhak")
    public suspend fun sourceSelectionCriterias(
        vararg
        argument: suspend BucketV2ReplicationConfigurationRuleSourceSelectionCriteriaArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            BucketV2ReplicationConfigurationRuleSourceSelectionCriteriaArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sourceSelectionCriterias = mapped
    }

    /**
     * @param argument Specifies special object selection criteria (documented below).
     */
    @JvmName("jqfreqyejatujhma")
    public suspend
    fun sourceSelectionCriterias(argument: suspend BucketV2ReplicationConfigurationRuleSourceSelectionCriteriaArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                BucketV2ReplicationConfigurationRuleSourceSelectionCriteriaArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.sourceSelectionCriterias = mapped
    }

    /**
     * @param values Specifies special object selection criteria (documented below).
     */
    @JvmName("wgkhoxdvsgmcaypt")
    public suspend fun sourceSelectionCriterias(
        vararg
        values: BucketV2ReplicationConfigurationRuleSourceSelectionCriteriaArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceSelectionCriterias = mapped
    }

    /**
     * @param value Status of the rule. Either `Enabled` or `Disabled`. The rule is ignored if status is not Enabled.
     */
    @JvmName("pmdjqusdhsmsklwt")
    public suspend fun status(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): BucketV2ReplicationConfigurationRuleArgs =
        BucketV2ReplicationConfigurationRuleArgs(
            deleteMarkerReplicationStatus = deleteMarkerReplicationStatus,
            destinations = destinations ?: throw PulumiNullFieldException("destinations"),
            filters = filters,
            id = id,
            prefix = prefix,
            priority = priority,
            sourceSelectionCriterias = sourceSelectionCriterias,
            status = status ?: throw PulumiNullFieldException("status"),
        )
}
