@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketV2ReplicationConfigurationRuleDestinationMetricArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property minutes Threshold within which objects are to be replicated. The only valid value is `15`.
 * @property status Status of replication metrics. Either `Enabled` or `Disabled`.
 */
public data class BucketV2ReplicationConfigurationRuleDestinationMetricArgs(
    public val minutes: Output<Int>? = null,
    public val status: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketV2ReplicationConfigurationRuleDestinationMetricArgs> {
    override fun toJava():
        com.pulumi.aws.s3.inputs.BucketV2ReplicationConfigurationRuleDestinationMetricArgs =
        com.pulumi.aws.s3.inputs.BucketV2ReplicationConfigurationRuleDestinationMetricArgs.builder()
            .minutes(minutes?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketV2ReplicationConfigurationRuleDestinationMetricArgs].
 */
@PulumiTagMarker
public class BucketV2ReplicationConfigurationRuleDestinationMetricArgsBuilder internal constructor() {
    private var minutes: Output<Int>? = null

    private var status: Output<String>? = null

    /**
     * @param value Threshold within which objects are to be replicated. The only valid value is `15`.
     */
    @JvmName("ijxkvdrqggxoefgb")
    public suspend fun minutes(`value`: Output<Int>) {
        this.minutes = value
    }

    /**
     * @param value Status of replication metrics. Either `Enabled` or `Disabled`.
     */
    @JvmName("ldhvxptmgpacmjxo")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Threshold within which objects are to be replicated. The only valid value is `15`.
     */
    @JvmName("ukkauvonasbskhgl")
    public suspend fun minutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minutes = mapped
    }

    /**
     * @param value Status of replication metrics. Either `Enabled` or `Disabled`.
     */
    @JvmName("aedbvaktguoexmpt")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): BucketV2ReplicationConfigurationRuleDestinationMetricArgs =
        BucketV2ReplicationConfigurationRuleDestinationMetricArgs(
            minutes = minutes,
            status = status,
        )
}
