@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketV2ReplicationConfigurationRuleFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property prefix Object keyname prefix that identifies subset of objects to which the rule applies. Must be less than or equal to 1024 characters in length.
 * @property tags A map of tags that identifies subset of objects to which the rule applies.
 * The rule applies only to objects having all the tags in its tagset.
 */
public data class BucketV2ReplicationConfigurationRuleFilterArgs(
    public val prefix: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketV2ReplicationConfigurationRuleFilterArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketV2ReplicationConfigurationRuleFilterArgs =
        com.pulumi.aws.s3.inputs.BucketV2ReplicationConfigurationRuleFilterArgs.builder()
            .prefix(prefix?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [BucketV2ReplicationConfigurationRuleFilterArgs].
 */
@PulumiTagMarker
public class BucketV2ReplicationConfigurationRuleFilterArgsBuilder internal constructor() {
    private var prefix: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Object keyname prefix that identifies subset of objects to which the rule applies. Must be less than or equal to 1024 characters in length.
     */
    @JvmName("lbeyissfccvrhjcn")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value A map of tags that identifies subset of objects to which the rule applies.
     * The rule applies only to objects having all the tags in its tagset.
     */
    @JvmName("rxmrbalvwygpjjax")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Object keyname prefix that identifies subset of objects to which the rule applies. Must be less than or equal to 1024 characters in length.
     */
    @JvmName("lxpydarveptwggsj")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    /**
     * @param value A map of tags that identifies subset of objects to which the rule applies.
     * The rule applies only to objects having all the tags in its tagset.
     */
    @JvmName("ikmvavdpiulsbjli")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags that identifies subset of objects to which the rule applies.
     * The rule applies only to objects having all the tags in its tagset.
     */
    @JvmName("tsgtwpvkchdljqdc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): BucketV2ReplicationConfigurationRuleFilterArgs =
        BucketV2ReplicationConfigurationRuleFilterArgs(
            prefix = prefix,
            tags = tags,
        )
}
