@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketV2ServerSideEncryptionConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property rules Single object for server-side encryption by default configuration. (documented below)
 */
public data class BucketV2ServerSideEncryptionConfigurationArgs(
    public val rules: Output<List<BucketV2ServerSideEncryptionConfigurationRuleArgs>>,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketV2ServerSideEncryptionConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketV2ServerSideEncryptionConfigurationArgs =
        com.pulumi.aws.s3.inputs.BucketV2ServerSideEncryptionConfigurationArgs.builder()
            .rules(
                rules.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [BucketV2ServerSideEncryptionConfigurationArgs].
 */
@PulumiTagMarker
public class BucketV2ServerSideEncryptionConfigurationArgsBuilder internal constructor() {
    private var rules: Output<List<BucketV2ServerSideEncryptionConfigurationRuleArgs>>? = null

    /**
     * @param value Single object for server-side encryption by default configuration. (documented below)
     */
    @JvmName("fogkliiexghfpypo")
    public suspend
    fun rules(`value`: Output<List<BucketV2ServerSideEncryptionConfigurationRuleArgs>>) {
        this.rules = value
    }

    @JvmName("hwptjsayuwfrcsyw")
    public suspend fun rules(
        vararg
        values: Output<BucketV2ServerSideEncryptionConfigurationRuleArgs>,
    ) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values Single object for server-side encryption by default configuration. (documented below)
     */
    @JvmName("smsuogbmmieiwvpk")
    public suspend
    fun rules(values: List<Output<BucketV2ServerSideEncryptionConfigurationRuleArgs>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value Single object for server-side encryption by default configuration. (documented below)
     */
    @JvmName("srupgnmbypkceqtx")
    public suspend fun rules(`value`: List<BucketV2ServerSideEncryptionConfigurationRuleArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param argument Single object for server-side encryption by default configuration. (documented below)
     */
    @JvmName("fuemwyjueooxuymd")
    public suspend
    fun rules(argument: List<suspend BucketV2ServerSideEncryptionConfigurationRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BucketV2ServerSideEncryptionConfigurationRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument Single object for server-side encryption by default configuration. (documented below)
     */
    @JvmName("tdomodmredaoqjbh")
    public suspend fun rules(
        vararg
        argument: suspend BucketV2ServerSideEncryptionConfigurationRuleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            BucketV2ServerSideEncryptionConfigurationRuleArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument Single object for server-side encryption by default configuration. (documented below)
     */
    @JvmName("ilnuhebolncurqhi")
    public suspend
    fun rules(argument: suspend BucketV2ServerSideEncryptionConfigurationRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            BucketV2ServerSideEncryptionConfigurationRuleArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param values Single object for server-side encryption by default configuration. (documented below)
     */
    @JvmName("tfblonpwsigsnflv")
    public suspend fun rules(vararg values: BucketV2ServerSideEncryptionConfigurationRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    internal fun build(): BucketV2ServerSideEncryptionConfigurationArgs =
        BucketV2ServerSideEncryptionConfigurationArgs(
            rules = rules ?: throw PulumiNullFieldException("rules"),
        )
}
