@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketV2ServerSideEncryptionConfigurationRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property applyServerSideEncryptionByDefaults Single object for setting server-side encryption by default. (documented below)
 * @property bucketKeyEnabled Whether or not to use [Amazon S3 Bucket Keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html) for SSE-KMS.
 */
public data class BucketV2ServerSideEncryptionConfigurationRuleArgs(
    public val applyServerSideEncryptionByDefaults:
    Output<List<BucketV2ServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefaultArgs>>,
    public val bucketKeyEnabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketV2ServerSideEncryptionConfigurationRuleArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketV2ServerSideEncryptionConfigurationRuleArgs =
        com.pulumi.aws.s3.inputs.BucketV2ServerSideEncryptionConfigurationRuleArgs.builder()
            .applyServerSideEncryptionByDefaults(
                applyServerSideEncryptionByDefaults.applyValue({ args0 ->
                    args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .bucketKeyEnabled(bucketKeyEnabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketV2ServerSideEncryptionConfigurationRuleArgs].
 */
@PulumiTagMarker
public class BucketV2ServerSideEncryptionConfigurationRuleArgsBuilder internal constructor() {
    private var applyServerSideEncryptionByDefaults:
        Output<List<BucketV2ServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefaultArgs>>? =
        null

    private var bucketKeyEnabled: Output<Boolean>? = null

    /**
     * @param value Single object for setting server-side encryption by default. (documented below)
     */
    @JvmName("imrmdrtethwkbdmd")
    public suspend
    fun applyServerSideEncryptionByDefaults(`value`: Output<List<BucketV2ServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefaultArgs>>) {
        this.applyServerSideEncryptionByDefaults = value
    }

    @JvmName("iaranefhhcyhwnsr")
    public suspend fun applyServerSideEncryptionByDefaults(
        vararg
        values: Output<BucketV2ServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefaultArgs>,
    ) {
        this.applyServerSideEncryptionByDefaults = Output.all(values.asList())
    }

    /**
     * @param values Single object for setting server-side encryption by default. (documented below)
     */
    @JvmName("mlfcogmbvqpsewbf")
    public suspend
    fun applyServerSideEncryptionByDefaults(values: List<Output<BucketV2ServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefaultArgs>>) {
        this.applyServerSideEncryptionByDefaults = Output.all(values)
    }

    /**
     * @param value Whether or not to use [Amazon S3 Bucket Keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html) for SSE-KMS.
     */
    @JvmName("wfgxarmtevesvcmf")
    public suspend fun bucketKeyEnabled(`value`: Output<Boolean>) {
        this.bucketKeyEnabled = value
    }

    /**
     * @param value Single object for setting server-side encryption by default. (documented below)
     */
    @JvmName("ltorwqhvbygbdmqn")
    public suspend
    fun applyServerSideEncryptionByDefaults(`value`: List<BucketV2ServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefaultArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applyServerSideEncryptionByDefaults = mapped
    }

    /**
     * @param argument Single object for setting server-side encryption by default. (documented below)
     */
    @JvmName("xabjruuswynbqccx")
    public suspend
    fun applyServerSideEncryptionByDefaults(argument: List<suspend BucketV2ServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefaultArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BucketV2ServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefaultArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.applyServerSideEncryptionByDefaults = mapped
    }

    /**
     * @param argument Single object for setting server-side encryption by default. (documented below)
     */
    @JvmName("toxghrqsdwijjymh")
    public suspend fun applyServerSideEncryptionByDefaults(
        vararg
        argument: suspend BucketV2ServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefaultArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            BucketV2ServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefaultArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.applyServerSideEncryptionByDefaults = mapped
    }

    /**
     * @param argument Single object for setting server-side encryption by default. (documented below)
     */
    @JvmName("gfixymdoffdaivec")
    public suspend
    fun applyServerSideEncryptionByDefaults(argument: suspend BucketV2ServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefaultArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                BucketV2ServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefaultArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.applyServerSideEncryptionByDefaults = mapped
    }

    /**
     * @param values Single object for setting server-side encryption by default. (documented below)
     */
    @JvmName("mvhysiuawibbfdgh")
    public suspend fun applyServerSideEncryptionByDefaults(
        vararg
        values: BucketV2ServerSideEncryptionConfigurationRuleApplyServerSideEncryptionByDefaultArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applyServerSideEncryptionByDefaults = mapped
    }

    /**
     * @param value Whether or not to use [Amazon S3 Bucket Keys](https://docs.aws.amazon.com/AmazonS3/latest/dev/bucket-key.html) for SSE-KMS.
     */
    @JvmName("ugounfntvkkqefsl")
    public suspend fun bucketKeyEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketKeyEnabled = mapped
    }

    internal fun build(): BucketV2ServerSideEncryptionConfigurationRuleArgs =
        BucketV2ServerSideEncryptionConfigurationRuleArgs(
            applyServerSideEncryptionByDefaults = applyServerSideEncryptionByDefaults ?: throw
                PulumiNullFieldException("applyServerSideEncryptionByDefaults"),
            bucketKeyEnabled = bucketKeyEnabled,
        )
}
