@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketV2WebsiteArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property errorDocument Absolute path to the document to return in case of a 4XX error.
 * @property indexDocument Amazon S3 returns this index document when requests are made to the root domain or any of the subfolders.
 * @property redirectAllRequestsTo Hostname to redirect all website requests for this bucket to. Hostname can optionally be prefixed with a protocol (`http://` or `https://`) to use when redirecting requests. The default is the protocol that is used in the original request.
 * @property routingRules JSON array containing [routing rules](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html)
 * describing redirect behavior and when redirects are applied.
 */
public data class BucketV2WebsiteArgs(
    public val errorDocument: Output<String>? = null,
    public val indexDocument: Output<String>? = null,
    public val redirectAllRequestsTo: Output<String>? = null,
    public val routingRules: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketV2WebsiteArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketV2WebsiteArgs =
        com.pulumi.aws.s3.inputs.BucketV2WebsiteArgs.builder()
            .errorDocument(errorDocument?.applyValue({ args0 -> args0 }))
            .indexDocument(indexDocument?.applyValue({ args0 -> args0 }))
            .redirectAllRequestsTo(redirectAllRequestsTo?.applyValue({ args0 -> args0 }))
            .routingRules(routingRules?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketV2WebsiteArgs].
 */
@PulumiTagMarker
public class BucketV2WebsiteArgsBuilder internal constructor() {
    private var errorDocument: Output<String>? = null

    private var indexDocument: Output<String>? = null

    private var redirectAllRequestsTo: Output<String>? = null

    private var routingRules: Output<String>? = null

    /**
     * @param value Absolute path to the document to return in case of a 4XX error.
     */
    @JvmName("oodaprdndotwqjiq")
    public suspend fun errorDocument(`value`: Output<String>) {
        this.errorDocument = value
    }

    /**
     * @param value Amazon S3 returns this index document when requests are made to the root domain or any of the subfolders.
     */
    @JvmName("qepurheteuexnaav")
    public suspend fun indexDocument(`value`: Output<String>) {
        this.indexDocument = value
    }

    /**
     * @param value Hostname to redirect all website requests for this bucket to. Hostname can optionally be prefixed with a protocol (`http://` or `https://`) to use when redirecting requests. The default is the protocol that is used in the original request.
     */
    @JvmName("byuelkyaikhgggyq")
    public suspend fun redirectAllRequestsTo(`value`: Output<String>) {
        this.redirectAllRequestsTo = value
    }

    /**
     * @param value JSON array containing [routing rules](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html)
     * describing redirect behavior and when redirects are applied.
     */
    @JvmName("htibsgfstymfqlry")
    public suspend fun routingRules(`value`: Output<String>) {
        this.routingRules = value
    }

    /**
     * @param value Absolute path to the document to return in case of a 4XX error.
     */
    @JvmName("kpcpoqtutiitsjng")
    public suspend fun errorDocument(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorDocument = mapped
    }

    /**
     * @param value Amazon S3 returns this index document when requests are made to the root domain or any of the subfolders.
     */
    @JvmName("htueyjgeqprpwtka")
    public suspend fun indexDocument(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.indexDocument = mapped
    }

    /**
     * @param value Hostname to redirect all website requests for this bucket to. Hostname can optionally be prefixed with a protocol (`http://` or `https://`) to use when redirecting requests. The default is the protocol that is used in the original request.
     */
    @JvmName("dbrfleeoblfmtbls")
    public suspend fun redirectAllRequestsTo(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redirectAllRequestsTo = mapped
    }

    /**
     * @param value JSON array containing [routing rules](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html)
     * describing redirect behavior and when redirects are applied.
     */
    @JvmName("hrkesbirrcbqwkjr")
    public suspend fun routingRules(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routingRules = mapped
    }

    internal fun build(): BucketV2WebsiteArgs = BucketV2WebsiteArgs(
        errorDocument = errorDocument,
        indexDocument = indexDocument,
        redirectAllRequestsTo = redirectAllRequestsTo,
        routingRules = routingRules,
    )
}
