@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketVersioningArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Enable versioning. Once you version-enable a bucket, it can never return to an unversioned state. You can, however, suspend versioning on that bucket.
 * @property mfaDelete Enable MFA delete for either `Change the versioning state of your bucket` or `Permanently delete an object version`. Default is `false`. This cannot be used to toggle this setting but is available to allow managed buckets to reflect the state in AWS
 */
public data class BucketVersioningArgs(
    public val enabled: Output<Boolean>? = null,
    public val mfaDelete: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketVersioningArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketVersioningArgs =
        com.pulumi.aws.s3.inputs.BucketVersioningArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .mfaDelete(mfaDelete?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketVersioningArgs].
 */
@PulumiTagMarker
public class BucketVersioningArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var mfaDelete: Output<Boolean>? = null

    /**
     * @param value Enable versioning. Once you version-enable a bucket, it can never return to an unversioned state. You can, however, suspend versioning on that bucket.
     */
    @JvmName("mkiuabyyvmnrounf")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Enable MFA delete for either `Change the versioning state of your bucket` or `Permanently delete an object version`. Default is `false`. This cannot be used to toggle this setting but is available to allow managed buckets to reflect the state in AWS
     */
    @JvmName("kmhunxqlwtybyerw")
    public suspend fun mfaDelete(`value`: Output<Boolean>) {
        this.mfaDelete = value
    }

    /**
     * @param value Enable versioning. Once you version-enable a bucket, it can never return to an unversioned state. You can, however, suspend versioning on that bucket.
     */
    @JvmName("fobokppjpksidcrr")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Enable MFA delete for either `Change the versioning state of your bucket` or `Permanently delete an object version`. Default is `false`. This cannot be used to toggle this setting but is available to allow managed buckets to reflect the state in AWS
     */
    @JvmName("rqcitmcifylpycab")
    public suspend fun mfaDelete(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mfaDelete = mapped
    }

    internal fun build(): BucketVersioningArgs = BucketVersioningArgs(
        enabled = enabled,
        mfaDelete = mfaDelete,
    )
}
