@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketVersioningV2VersioningConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property mfaDelete Specifies whether MFA delete is enabled in the bucket versioning configuration. Valid values: `Enabled` or `Disabled`.
 * @property status Versioning state of the bucket. Valid values: `Enabled`, `Suspended`, or `Disabled`. `Disabled` should only be used when creating or importing resources that correspond to unversioned S3 buckets.
 */
public data class BucketVersioningV2VersioningConfigurationArgs(
    public val mfaDelete: Output<String>? = null,
    public val status: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketVersioningV2VersioningConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketVersioningV2VersioningConfigurationArgs =
        com.pulumi.aws.s3.inputs.BucketVersioningV2VersioningConfigurationArgs.builder()
            .mfaDelete(mfaDelete?.applyValue({ args0 -> args0 }))
            .status(status.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketVersioningV2VersioningConfigurationArgs].
 */
@PulumiTagMarker
public class BucketVersioningV2VersioningConfigurationArgsBuilder internal constructor() {
    private var mfaDelete: Output<String>? = null

    private var status: Output<String>? = null

    /**
     * @param value Specifies whether MFA delete is enabled in the bucket versioning configuration. Valid values: `Enabled` or `Disabled`.
     */
    @JvmName("ncooucokebngdjlf")
    public suspend fun mfaDelete(`value`: Output<String>) {
        this.mfaDelete = value
    }

    /**
     * @param value Versioning state of the bucket. Valid values: `Enabled`, `Suspended`, or `Disabled`. `Disabled` should only be used when creating or importing resources that correspond to unversioned S3 buckets.
     */
    @JvmName("ymejsborwmcudejn")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Specifies whether MFA delete is enabled in the bucket versioning configuration. Valid values: `Enabled` or `Disabled`.
     */
    @JvmName("rolrmjvptwcvhapk")
    public suspend fun mfaDelete(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mfaDelete = mapped
    }

    /**
     * @param value Versioning state of the bucket. Valid values: `Enabled`, `Suspended`, or `Disabled`. `Disabled` should only be used when creating or importing resources that correspond to unversioned S3 buckets.
     */
    @JvmName("gucyjjlfwmnqqaxx")
    public suspend fun status(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): BucketVersioningV2VersioningConfigurationArgs =
        BucketVersioningV2VersioningConfigurationArgs(
            mfaDelete = mfaDelete,
            status = status ?: throw PulumiNullFieldException("status"),
        )
}
