@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketWebsiteArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property errorDocument An absolute path to the document to return in case of a 4XX error.
 * @property indexDocument Amazon S3 returns this index document when requests are made to the root domain or any of the subfolders.
 * @property redirectAllRequestsTo A hostname to redirect all website requests for this bucket to. Hostname can optionally be prefixed with a protocol (`http://` or `https://`) to use when redirecting requests. The default is the protocol that is used in the original request.
 * @property routingRules A json array containing [routing rules](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html)
 * describing redirect behavior and when redirects are applied.
 * The `CORS` object supports the following:
 */
public data class BucketWebsiteArgs(
    public val errorDocument: Output<String>? = null,
    public val indexDocument: Output<String>? = null,
    public val redirectAllRequestsTo: Output<String>? = null,
    public val routingRules: Output<Either<String, List<String>>>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketWebsiteArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketWebsiteArgs =
        com.pulumi.aws.s3.inputs.BucketWebsiteArgs.builder()
            .errorDocument(errorDocument?.applyValue({ args0 -> args0 }))
            .indexDocument(indexDocument?.applyValue({ args0 -> args0 }))
            .redirectAllRequestsTo(redirectAllRequestsTo?.applyValue({ args0 -> args0 }))
            .routingRules(
                routingRules?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.map({ args0 -> args0 })
                    })
                }),
            ).build()
}

/**
 * Builder for [BucketWebsiteArgs].
 */
@PulumiTagMarker
public class BucketWebsiteArgsBuilder internal constructor() {
    private var errorDocument: Output<String>? = null

    private var indexDocument: Output<String>? = null

    private var redirectAllRequestsTo: Output<String>? = null

    private var routingRules: Output<Either<String, List<String>>>? = null

    /**
     * @param value An absolute path to the document to return in case of a 4XX error.
     */
    @JvmName("vkmmrvdgilnvvlbw")
    public suspend fun errorDocument(`value`: Output<String>) {
        this.errorDocument = value
    }

    /**
     * @param value Amazon S3 returns this index document when requests are made to the root domain or any of the subfolders.
     */
    @JvmName("vcltmxvvpqwpaqul")
    public suspend fun indexDocument(`value`: Output<String>) {
        this.indexDocument = value
    }

    /**
     * @param value A hostname to redirect all website requests for this bucket to. Hostname can optionally be prefixed with a protocol (`http://` or `https://`) to use when redirecting requests. The default is the protocol that is used in the original request.
     */
    @JvmName("bnwukxolgxjsmwqt")
    public suspend fun redirectAllRequestsTo(`value`: Output<String>) {
        this.redirectAllRequestsTo = value
    }

    /**
     * @param value A json array containing [routing rules](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html)
     * describing redirect behavior and when redirects are applied.
     * The `CORS` object supports the following:
     */
    @JvmName("bmbkxcxgwqbcwhqh")
    public suspend fun routingRules(`value`: Output<Either<String, List<String>>>) {
        this.routingRules = value
    }

    /**
     * @param value An absolute path to the document to return in case of a 4XX error.
     */
    @JvmName("ypnyjiaegmuepcqd")
    public suspend fun errorDocument(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorDocument = mapped
    }

    /**
     * @param value Amazon S3 returns this index document when requests are made to the root domain or any of the subfolders.
     */
    @JvmName("wkkcaojmlsxoogox")
    public suspend fun indexDocument(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.indexDocument = mapped
    }

    /**
     * @param value A hostname to redirect all website requests for this bucket to. Hostname can optionally be prefixed with a protocol (`http://` or `https://`) to use when redirecting requests. The default is the protocol that is used in the original request.
     */
    @JvmName("wymrrwvaqcawyrnb")
    public suspend fun redirectAllRequestsTo(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redirectAllRequestsTo = mapped
    }

    /**
     * @param value A json array containing [routing rules](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html)
     * describing redirect behavior and when redirects are applied.
     * The `CORS` object supports the following:
     */
    @JvmName("vnwvcetxvvfetykk")
    public suspend fun routingRules(`value`: Either<String, List<String>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routingRules = mapped
    }

    /**
     * @param value A json array containing [routing rules](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html)
     * describing redirect behavior and when redirects are applied.
     * The `CORS` object supports the following:
     */
    @JvmName("bksxwkeiekspxfod")
    public fun routingRules(`value`: String) {
        val toBeMapped = Either.ofLeft<String, List<String>>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routingRules = mapped
    }

    /**
     * @param value A json array containing [routing rules](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-s3-websiteconfiguration-routingrules.html)
     * describing redirect behavior and when redirects are applied.
     * The `CORS` object supports the following:
     */
    @JvmName("npssqvulbjakmdmt")
    public fun routingRules(`value`: List<String>) {
        val toBeMapped = Either.ofRight<String, List<String>>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routingRules = mapped
    }

    internal fun build(): BucketWebsiteArgs = BucketWebsiteArgs(
        errorDocument = errorDocument,
        indexDocument = indexDocument,
        redirectAllRequestsTo = redirectAllRequestsTo,
        routingRules = routingRules,
    )
}
