@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketWebsiteConfigurationV2ErrorDocumentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property key Object key name to use when a 4XX class error occurs.
 */
public data class BucketWebsiteConfigurationV2ErrorDocumentArgs(
    public val key: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketWebsiteConfigurationV2ErrorDocumentArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketWebsiteConfigurationV2ErrorDocumentArgs =
        com.pulumi.aws.s3.inputs.BucketWebsiteConfigurationV2ErrorDocumentArgs.builder()
            .key(key.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketWebsiteConfigurationV2ErrorDocumentArgs].
 */
@PulumiTagMarker
public class BucketWebsiteConfigurationV2ErrorDocumentArgsBuilder internal constructor() {
    private var key: Output<String>? = null

    /**
     * @param value Object key name to use when a 4XX class error occurs.
     */
    @JvmName("glqdbylntioaifxf")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Object key name to use when a 4XX class error occurs.
     */
    @JvmName("xsnmlfsjpdrkyqqi")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    internal fun build(): BucketWebsiteConfigurationV2ErrorDocumentArgs =
        BucketWebsiteConfigurationV2ErrorDocumentArgs(
            key = key ?: throw PulumiNullFieldException("key"),
        )
}
