@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketWebsiteConfigurationV2RoutingRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property condition Configuration block for describing a condition that must be met for the specified redirect to apply. See below.
 * @property redirect Configuration block for redirect information. See below.
 */
public data class BucketWebsiteConfigurationV2RoutingRuleArgs(
    public val condition: Output<BucketWebsiteConfigurationV2RoutingRuleConditionArgs>? = null,
    public val redirect: Output<BucketWebsiteConfigurationV2RoutingRuleRedirectArgs>,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketWebsiteConfigurationV2RoutingRuleArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.BucketWebsiteConfigurationV2RoutingRuleArgs =
        com.pulumi.aws.s3.inputs.BucketWebsiteConfigurationV2RoutingRuleArgs.builder()
            .condition(condition?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .redirect(redirect.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [BucketWebsiteConfigurationV2RoutingRuleArgs].
 */
@PulumiTagMarker
public class BucketWebsiteConfigurationV2RoutingRuleArgsBuilder internal constructor() {
    private var condition: Output<BucketWebsiteConfigurationV2RoutingRuleConditionArgs>? = null

    private var redirect: Output<BucketWebsiteConfigurationV2RoutingRuleRedirectArgs>? = null

    /**
     * @param value Configuration block for describing a condition that must be met for the specified redirect to apply. See below.
     */
    @JvmName("ykmdcwdejvcqguyc")
    public suspend
    fun condition(`value`: Output<BucketWebsiteConfigurationV2RoutingRuleConditionArgs>) {
        this.condition = value
    }

    /**
     * @param value Configuration block for redirect information. See below.
     */
    @JvmName("jmjckltkyxfxnaie")
    public suspend
    fun redirect(`value`: Output<BucketWebsiteConfigurationV2RoutingRuleRedirectArgs>) {
        this.redirect = value
    }

    /**
     * @param value Configuration block for describing a condition that must be met for the specified redirect to apply. See below.
     */
    @JvmName("tvhxrmqmwmasbapl")
    public suspend fun condition(`value`: BucketWebsiteConfigurationV2RoutingRuleConditionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.condition = mapped
    }

    /**
     * @param argument Configuration block for describing a condition that must be met for the specified redirect to apply. See below.
     */
    @JvmName("psbvhtnvsloaqerx")
    public suspend
    fun condition(argument: suspend BucketWebsiteConfigurationV2RoutingRuleConditionArgsBuilder.() -> Unit) {
        val toBeMapped = BucketWebsiteConfigurationV2RoutingRuleConditionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.condition = mapped
    }

    /**
     * @param value Configuration block for redirect information. See below.
     */
    @JvmName("sqygyoofouqfgogh")
    public suspend fun redirect(`value`: BucketWebsiteConfigurationV2RoutingRuleRedirectArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.redirect = mapped
    }

    /**
     * @param argument Configuration block for redirect information. See below.
     */
    @JvmName("ppkcgkhcbxdnaspu")
    public suspend
    fun redirect(argument: suspend BucketWebsiteConfigurationV2RoutingRuleRedirectArgsBuilder.() -> Unit) {
        val toBeMapped = BucketWebsiteConfigurationV2RoutingRuleRedirectArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.redirect = mapped
    }

    internal fun build(): BucketWebsiteConfigurationV2RoutingRuleArgs =
        BucketWebsiteConfigurationV2RoutingRuleArgs(
            condition = condition,
            redirect = redirect ?: throw PulumiNullFieldException("redirect"),
        )
}
