@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.BucketWebsiteConfigurationV2RoutingRuleRedirectArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property hostName Host name to use in the redirect request.
 * @property httpRedirectCode HTTP redirect code to use on the response.
 * @property protocol Protocol to use when redirecting requests. The default is the protocol that is used in the original request. Valid values: `http`, `https`.
 * @property replaceKeyPrefixWith Object key prefix to use in the redirect request. For example, to redirect requests for all pages with prefix `docs/` (objects in the `docs/` folder) to `documents/`, you can set a `condition` block with `key_prefix_equals` set to `docs/` and in the `redirect` set `replace_key_prefix_with` to `/documents`.
 * @property replaceKeyWith Specific object key to use in the redirect request. For example, redirect request to `error.html`.
 */
public data class BucketWebsiteConfigurationV2RoutingRuleRedirectArgs(
    public val hostName: Output<String>? = null,
    public val httpRedirectCode: Output<String>? = null,
    public val protocol: Output<String>? = null,
    public val replaceKeyPrefixWith: Output<String>? = null,
    public val replaceKeyWith: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.BucketWebsiteConfigurationV2RoutingRuleRedirectArgs> {
    override fun toJava():
        com.pulumi.aws.s3.inputs.BucketWebsiteConfigurationV2RoutingRuleRedirectArgs =
        com.pulumi.aws.s3.inputs.BucketWebsiteConfigurationV2RoutingRuleRedirectArgs.builder()
            .hostName(hostName?.applyValue({ args0 -> args0 }))
            .httpRedirectCode(httpRedirectCode?.applyValue({ args0 -> args0 }))
            .protocol(protocol?.applyValue({ args0 -> args0 }))
            .replaceKeyPrefixWith(replaceKeyPrefixWith?.applyValue({ args0 -> args0 }))
            .replaceKeyWith(replaceKeyWith?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BucketWebsiteConfigurationV2RoutingRuleRedirectArgs].
 */
@PulumiTagMarker
public class BucketWebsiteConfigurationV2RoutingRuleRedirectArgsBuilder internal constructor() {
    private var hostName: Output<String>? = null

    private var httpRedirectCode: Output<String>? = null

    private var protocol: Output<String>? = null

    private var replaceKeyPrefixWith: Output<String>? = null

    private var replaceKeyWith: Output<String>? = null

    /**
     * @param value Host name to use in the redirect request.
     */
    @JvmName("nypsavupsnhccnem")
    public suspend fun hostName(`value`: Output<String>) {
        this.hostName = value
    }

    /**
     * @param value HTTP redirect code to use on the response.
     */
    @JvmName("omdjuivhngcompql")
    public suspend fun httpRedirectCode(`value`: Output<String>) {
        this.httpRedirectCode = value
    }

    /**
     * @param value Protocol to use when redirecting requests. The default is the protocol that is used in the original request. Valid values: `http`, `https`.
     */
    @JvmName("yheonhhtiufwmefw")
    public suspend fun protocol(`value`: Output<String>) {
        this.protocol = value
    }

    /**
     * @param value Object key prefix to use in the redirect request. For example, to redirect requests for all pages with prefix `docs/` (objects in the `docs/` folder) to `documents/`, you can set a `condition` block with `key_prefix_equals` set to `docs/` and in the `redirect` set `replace_key_prefix_with` to `/documents`.
     */
    @JvmName("klqlgihdaaqddvft")
    public suspend fun replaceKeyPrefixWith(`value`: Output<String>) {
        this.replaceKeyPrefixWith = value
    }

    /**
     * @param value Specific object key to use in the redirect request. For example, redirect request to `error.html`.
     */
    @JvmName("ecrpelhioyoroxgy")
    public suspend fun replaceKeyWith(`value`: Output<String>) {
        this.replaceKeyWith = value
    }

    /**
     * @param value Host name to use in the redirect request.
     */
    @JvmName("ndkamhyetidvskey")
    public suspend fun hostName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostName = mapped
    }

    /**
     * @param value HTTP redirect code to use on the response.
     */
    @JvmName("habfpjuujvamuemy")
    public suspend fun httpRedirectCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpRedirectCode = mapped
    }

    /**
     * @param value Protocol to use when redirecting requests. The default is the protocol that is used in the original request. Valid values: `http`, `https`.
     */
    @JvmName("ghvrlvffnayrogdb")
    public suspend fun protocol(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocol = mapped
    }

    /**
     * @param value Object key prefix to use in the redirect request. For example, to redirect requests for all pages with prefix `docs/` (objects in the `docs/` folder) to `documents/`, you can set a `condition` block with `key_prefix_equals` set to `docs/` and in the `redirect` set `replace_key_prefix_with` to `/documents`.
     */
    @JvmName("xpsvbcfrweamxmkc")
    public suspend fun replaceKeyPrefixWith(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replaceKeyPrefixWith = mapped
    }

    /**
     * @param value Specific object key to use in the redirect request. For example, redirect request to `error.html`.
     */
    @JvmName("kepstktcwyjqcohp")
    public suspend fun replaceKeyWith(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replaceKeyWith = mapped
    }

    internal fun build(): BucketWebsiteConfigurationV2RoutingRuleRedirectArgs =
        BucketWebsiteConfigurationV2RoutingRuleRedirectArgs(
            hostName = hostName,
            httpRedirectCode = httpRedirectCode,
            protocol = protocol,
            replaceKeyPrefixWith = replaceKeyPrefixWith,
            replaceKeyWith = replaceKeyWith,
        )
}
