@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.GetAccountPublicAccessBlockPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAccountPublicAccessBlock.
 * @property accountId AWS account ID to configure. Defaults to automatically determined account ID of the AWS provider.
 */
public data class GetAccountPublicAccessBlockPlainArgs(
    public val accountId: String? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.GetAccountPublicAccessBlockPlainArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.GetAccountPublicAccessBlockPlainArgs =
        com.pulumi.aws.s3.inputs.GetAccountPublicAccessBlockPlainArgs.builder()
            .accountId(accountId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAccountPublicAccessBlockPlainArgs].
 */
@PulumiTagMarker
public class GetAccountPublicAccessBlockPlainArgsBuilder internal constructor() {
    private var accountId: String? = null

    /**
     * @param value AWS account ID to configure. Defaults to automatically determined account ID of the AWS provider.
     */
    @JvmName("egyhjpdmhxsehoxc")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.accountId = mapped
    }

    internal fun build(): GetAccountPublicAccessBlockPlainArgs = GetAccountPublicAccessBlockPlainArgs(
        accountId = accountId,
    )
}
