@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.GetBucketObjectPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Deprecated
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getBucketObject.
 * @property bucket Name of the bucket to read the object from. Alternatively, an [S3 access point](https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html) ARN can be specified
 * @property key Full path to the object inside the bucket
 * @property range
 * @property tags Map of tags assigned to the object.
 * @property versionId Specific version ID of the object returned (defaults to latest version)
 */
public data class GetBucketObjectPlainArgs(
    @Deprecated(
        message = """
  Use the aws_s3_object data source instead
  """,
    )
    public val bucket: String,
    public val key: String,
    public val range: String? = null,
    public val tags: Map<String, String>? = null,
    public val versionId: String? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.GetBucketObjectPlainArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.GetBucketObjectPlainArgs =
        com.pulumi.aws.s3.inputs.GetBucketObjectPlainArgs.builder()
            .bucket(bucket.let({ args0 -> args0 }))
            .key(key.let({ args0 -> args0 }))
            .range(range?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .versionId(versionId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBucketObjectPlainArgs].
 */
@PulumiTagMarker
public class GetBucketObjectPlainArgsBuilder internal constructor() {
    private var bucket: String? = null

    private var key: String? = null

    private var range: String? = null

    private var tags: Map<String, String>? = null

    private var versionId: String? = null

    /**
     * @param value Name of the bucket to read the object from. Alternatively, an [S3 access point](https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html) ARN can be specified
     */
    @Deprecated(
        message = """
  Use the aws_s3_object data source instead
  """,
    )
    @JvmName("xvwlaeuiwdxmrohs")
    public suspend fun bucket(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.bucket = mapped
    }

    /**
     * @param value Full path to the object inside the bucket
     */
    @JvmName("reskmowntsetbwms")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.key = mapped
    }

    /**
     * @param value
     */
    @JvmName("vurbhrubbovrbjwi")
    public suspend fun range(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.range = mapped
    }

    /**
     * @param value Map of tags assigned to the object.
     */
    @JvmName("oteqgfyjfbnfvjks")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Map of tags assigned to the object.
     */
    @JvmName("yulvgpoemmpwonli")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value Specific version ID of the object returned (defaults to latest version)
     */
    @JvmName("jedcxbnpgluqggjf")
    public suspend fun versionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.versionId = mapped
    }

    internal fun build(): GetBucketObjectPlainArgs = GetBucketObjectPlainArgs(
        bucket = bucket ?: throw PulumiNullFieldException("bucket"),
        key = key ?: throw PulumiNullFieldException("key"),
        range = range,
        tags = tags,
        versionId = versionId,
    )
}
