@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.GetBucketPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getBucket.
 * @property bucket Name of the bucket
 */
public data class GetBucketPlainArgs(
    public val bucket: String,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.GetBucketPlainArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.GetBucketPlainArgs =
        com.pulumi.aws.s3.inputs.GetBucketPlainArgs.builder()
            .bucket(bucket.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBucketPlainArgs].
 */
@PulumiTagMarker
public class GetBucketPlainArgsBuilder internal constructor() {
    private var bucket: String? = null

    /**
     * @param value Name of the bucket
     */
    @JvmName("fmmcwyuyhgikobpr")
    public suspend fun bucket(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.bucket = mapped
    }

    internal fun build(): GetBucketPlainArgs = GetBucketPlainArgs(
        bucket = bucket ?: throw PulumiNullFieldException("bucket"),
    )
}
