@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.GetBucketPolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getBucketPolicy.
 * @property bucket Bucket name.
 */
public data class GetBucketPolicyPlainArgs(
    public val bucket: String,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.GetBucketPolicyPlainArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.GetBucketPolicyPlainArgs =
        com.pulumi.aws.s3.inputs.GetBucketPolicyPlainArgs.builder()
            .bucket(bucket.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBucketPolicyPlainArgs].
 */
@PulumiTagMarker
public class GetBucketPolicyPlainArgsBuilder internal constructor() {
    private var bucket: String? = null

    /**
     * @param value Bucket name.
     */
    @JvmName("yoooawpxmkduaeov")
    public suspend fun bucket(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.bucket = mapped
    }

    internal fun build(): GetBucketPolicyPlainArgs = GetBucketPolicyPlainArgs(
        bucket = bucket ?: throw PulumiNullFieldException("bucket"),
    )
}
