@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.GetObjectsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getObjects.
 * @property bucket Lists object keys in this S3 bucket. Alternatively, an [S3 access point](https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html) ARN can be specified
 * @property delimiter Character used to group keys (Default: none)
 * @property encodingType Encodes keys using this method (Default: none; besides none, only "url" can be used)
 * @property fetchOwner Boolean specifying whether to populate the owner list (Default: false)
 * @property maxKeys Maximum object keys to return (Default: 1000)
 * @property prefix Limits results to object keys with this prefix (Default: none)
 * @property requestPayer Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. If included, the only valid value is `requester`.
 * @property startAfter Returns key names lexicographically after a specific object key in your bucket (Default: none; S3 lists object keys in UTF-8 character encoding in lexicographical order)
 */
public data class GetObjectsPlainArgs(
    public val bucket: String,
    public val delimiter: String? = null,
    public val encodingType: String? = null,
    public val fetchOwner: Boolean? = null,
    public val maxKeys: Int? = null,
    public val prefix: String? = null,
    public val requestPayer: String? = null,
    public val startAfter: String? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.GetObjectsPlainArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.GetObjectsPlainArgs =
        com.pulumi.aws.s3.inputs.GetObjectsPlainArgs.builder()
            .bucket(bucket.let({ args0 -> args0 }))
            .delimiter(delimiter?.let({ args0 -> args0 }))
            .encodingType(encodingType?.let({ args0 -> args0 }))
            .fetchOwner(fetchOwner?.let({ args0 -> args0 }))
            .maxKeys(maxKeys?.let({ args0 -> args0 }))
            .prefix(prefix?.let({ args0 -> args0 }))
            .requestPayer(requestPayer?.let({ args0 -> args0 }))
            .startAfter(startAfter?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetObjectsPlainArgs].
 */
@PulumiTagMarker
public class GetObjectsPlainArgsBuilder internal constructor() {
    private var bucket: String? = null

    private var delimiter: String? = null

    private var encodingType: String? = null

    private var fetchOwner: Boolean? = null

    private var maxKeys: Int? = null

    private var prefix: String? = null

    private var requestPayer: String? = null

    private var startAfter: String? = null

    /**
     * @param value Lists object keys in this S3 bucket. Alternatively, an [S3 access point](https://docs.aws.amazon.com/AmazonS3/latest/dev/using-access-points.html) ARN can be specified
     */
    @JvmName("qtpwkclcmqnjgcln")
    public suspend fun bucket(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.bucket = mapped
    }

    /**
     * @param value Character used to group keys (Default: none)
     */
    @JvmName("kyvnyntwfcxeexil")
    public suspend fun delimiter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.delimiter = mapped
    }

    /**
     * @param value Encodes keys using this method (Default: none; besides none, only "url" can be used)
     */
    @JvmName("liaygbfhmjbcxdtt")
    public suspend fun encodingType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.encodingType = mapped
    }

    /**
     * @param value Boolean specifying whether to populate the owner list (Default: false)
     */
    @JvmName("gtfsflidvxbmeyqr")
    public suspend fun fetchOwner(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.fetchOwner = mapped
    }

    /**
     * @param value Maximum object keys to return (Default: 1000)
     */
    @JvmName("iwudqddjspqrbtwx")
    public suspend fun maxKeys(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.maxKeys = mapped
    }

    /**
     * @param value Limits results to object keys with this prefix (Default: none)
     */
    @JvmName("unqtxbnkawuxsmsq")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.prefix = mapped
    }

    /**
     * @param value Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. If included, the only valid value is `requester`.
     */
    @JvmName("ykaauvlovqaemjwd")
    public suspend fun requestPayer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.requestPayer = mapped
    }

    /**
     * @param value Returns key names lexicographically after a specific object key in your bucket (Default: none; S3 lists object keys in UTF-8 character encoding in lexicographical order)
     */
    @JvmName("yfefcqlljklmurwx")
    public suspend fun startAfter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.startAfter = mapped
    }

    internal fun build(): GetObjectsPlainArgs = GetObjectsPlainArgs(
        bucket = bucket ?: throw PulumiNullFieldException("bucket"),
        delimiter = delimiter,
        encodingType = encodingType,
        fetchOwner = fetchOwner,
        maxKeys = maxKeys,
        prefix = prefix,
        requestPayer = requestPayer,
        startAfter = startAfter,
    )
}
