@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.InventoryDestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property bucket S3 bucket configuration where inventory results are published (documented below).
 */
public data class InventoryDestinationArgs(
    public val bucket: Output<InventoryDestinationBucketArgs>,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.InventoryDestinationArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.InventoryDestinationArgs =
        com.pulumi.aws.s3.inputs.InventoryDestinationArgs.builder()
            .bucket(bucket.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [InventoryDestinationArgs].
 */
@PulumiTagMarker
public class InventoryDestinationArgsBuilder internal constructor() {
    private var bucket: Output<InventoryDestinationBucketArgs>? = null

    /**
     * @param value S3 bucket configuration where inventory results are published (documented below).
     */
    @JvmName("vyobcuyotdvelyrn")
    public suspend fun bucket(`value`: Output<InventoryDestinationBucketArgs>) {
        this.bucket = value
    }

    /**
     * @param value S3 bucket configuration where inventory results are published (documented below).
     */
    @JvmName("rjsibtlrhepnrvrt")
    public suspend fun bucket(`value`: InventoryDestinationBucketArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bucket = mapped
    }

    /**
     * @param argument S3 bucket configuration where inventory results are published (documented below).
     */
    @JvmName("ootsyeymgrusuejd")
    public suspend fun bucket(argument: suspend InventoryDestinationBucketArgsBuilder.() -> Unit) {
        val toBeMapped = InventoryDestinationBucketArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.bucket = mapped
    }

    internal fun build(): InventoryDestinationArgs = InventoryDestinationArgs(
        bucket = bucket ?: throw PulumiNullFieldException("bucket"),
    )
}
