@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.InventoryDestinationBucketEncryptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property sseKms Specifies to use server-side encryption with AWS KMS-managed keys to encrypt the inventory file (documented below).
 * @property sseS3 Specifies to use server-side encryption with Amazon S3-managed keys (SSE-S3) to encrypt the inventory file.
 */
public data class InventoryDestinationBucketEncryptionArgs(
    public val sseKms: Output<InventoryDestinationBucketEncryptionSseKmsArgs>? = null,
    public val sseS3: Output<InventoryDestinationBucketEncryptionSseS3Args>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.InventoryDestinationBucketEncryptionArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.InventoryDestinationBucketEncryptionArgs =
        com.pulumi.aws.s3.inputs.InventoryDestinationBucketEncryptionArgs.builder()
            .sseKms(sseKms?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sseS3(sseS3?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [InventoryDestinationBucketEncryptionArgs].
 */
@PulumiTagMarker
public class InventoryDestinationBucketEncryptionArgsBuilder internal constructor() {
    private var sseKms: Output<InventoryDestinationBucketEncryptionSseKmsArgs>? = null

    private var sseS3: Output<InventoryDestinationBucketEncryptionSseS3Args>? = null

    /**
     * @param value Specifies to use server-side encryption with AWS KMS-managed keys to encrypt the inventory file (documented below).
     */
    @JvmName("rtpdeesuaoinptkx")
    public suspend fun sseKms(`value`: Output<InventoryDestinationBucketEncryptionSseKmsArgs>) {
        this.sseKms = value
    }

    /**
     * @param value Specifies to use server-side encryption with Amazon S3-managed keys (SSE-S3) to encrypt the inventory file.
     */
    @JvmName("aflpyedfohvududv")
    public suspend fun sseS3(`value`: Output<InventoryDestinationBucketEncryptionSseS3Args>) {
        this.sseS3 = value
    }

    /**
     * @param value Specifies to use server-side encryption with AWS KMS-managed keys to encrypt the inventory file (documented below).
     */
    @JvmName("jsiqcoiflccwccxb")
    public suspend fun sseKms(`value`: InventoryDestinationBucketEncryptionSseKmsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sseKms = mapped
    }

    /**
     * @param argument Specifies to use server-side encryption with AWS KMS-managed keys to encrypt the inventory file (documented below).
     */
    @JvmName("qaghhpwqlidubawv")
    public suspend
    fun sseKms(argument: suspend InventoryDestinationBucketEncryptionSseKmsArgsBuilder.() -> Unit) {
        val toBeMapped = InventoryDestinationBucketEncryptionSseKmsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sseKms = mapped
    }

    /**
     * @param value Specifies to use server-side encryption with Amazon S3-managed keys (SSE-S3) to encrypt the inventory file.
     */
    @JvmName("wgvfqoyptgnrceaa")
    public suspend fun sseS3(`value`: InventoryDestinationBucketEncryptionSseS3Args?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sseS3 = mapped
    }

    /**
     * @param argument Specifies to use server-side encryption with Amazon S3-managed keys (SSE-S3) to encrypt the inventory file.
     */
    @JvmName("rppowljequuybdef")
    public suspend
    fun sseS3(argument: suspend InventoryDestinationBucketEncryptionSseS3ArgsBuilder.() -> Unit) {
        val toBeMapped = InventoryDestinationBucketEncryptionSseS3ArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sseS3 = mapped
    }

    internal fun build(): InventoryDestinationBucketEncryptionArgs =
        InventoryDestinationBucketEncryptionArgs(
            sseKms = sseKms,
            sseS3 = sseS3,
        )
}
