@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.InventoryFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property prefix Prefix that an object must have to be included in the inventory results.
 */
public data class InventoryFilterArgs(
    public val prefix: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.InventoryFilterArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.InventoryFilterArgs =
        com.pulumi.aws.s3.inputs.InventoryFilterArgs.builder()
            .prefix(prefix?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InventoryFilterArgs].
 */
@PulumiTagMarker
public class InventoryFilterArgsBuilder internal constructor() {
    private var prefix: Output<String>? = null

    /**
     * @param value Prefix that an object must have to be included in the inventory results.
     */
    @JvmName("uiybsdcldjbqpqoj")
    public suspend fun prefix(`value`: Output<String>) {
        this.prefix = value
    }

    /**
     * @param value Prefix that an object must have to be included in the inventory results.
     */
    @JvmName("pkplvkhroygyxufx")
    public suspend fun prefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefix = mapped
    }

    internal fun build(): InventoryFilterArgs = InventoryFilterArgs(
        prefix = prefix,
    )
}
