@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.InventoryScheduleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property frequency Specifies how frequently inventory results are produced. Valid values: `Daily`, `Weekly`.
 */
public data class InventoryScheduleArgs(
    public val frequency: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.InventoryScheduleArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.InventoryScheduleArgs =
        com.pulumi.aws.s3.inputs.InventoryScheduleArgs.builder()
            .frequency(frequency.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InventoryScheduleArgs].
 */
@PulumiTagMarker
public class InventoryScheduleArgsBuilder internal constructor() {
    private var frequency: Output<String>? = null

    /**
     * @param value Specifies how frequently inventory results are produced. Valid values: `Daily`, `Weekly`.
     */
    @JvmName("dvcswwfshimnaiig")
    public suspend fun frequency(`value`: Output<String>) {
        this.frequency = value
    }

    /**
     * @param value Specifies how frequently inventory results are produced. Valid values: `Daily`, `Weekly`.
     */
    @JvmName("krvqxbcbfsebexni")
    public suspend fun frequency(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frequency = mapped
    }

    internal fun build(): InventoryScheduleArgs = InventoryScheduleArgs(
        frequency = frequency ?: throw PulumiNullFieldException("frequency"),
    )
}
