@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.inputs

import com.pulumi.aws.s3.inputs.ObjectCopyGrantArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property email Email address of the grantee. Used only when `type` is `AmazonCustomerByEmail`.
 * @property id Canonical user ID of the grantee. Used only when `type` is `CanonicalUser`.
 * @property permissions List of permissions to grant to grantee. Valid values are `READ`, `READ_ACP`, `WRITE_ACP`, `FULL_CONTROL`.
 * @property type Type of grantee. Valid values are `CanonicalUser`, `Group`, and `AmazonCustomerByEmail`.
 * This configuration block has the following optional arguments (one of the three is required):
 * @property uri URI of the grantee group. Used only when `type` is `Group`.
 */
public data class ObjectCopyGrantArgs(
    public val email: Output<String>? = null,
    public val id: Output<String>? = null,
    public val permissions: Output<List<String>>,
    public val type: Output<String>,
    public val uri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.s3.inputs.ObjectCopyGrantArgs> {
    override fun toJava(): com.pulumi.aws.s3.inputs.ObjectCopyGrantArgs =
        com.pulumi.aws.s3.inputs.ObjectCopyGrantArgs.builder()
            .email(email?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .permissions(permissions.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .type(type.applyValue({ args0 -> args0 }))
            .uri(uri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ObjectCopyGrantArgs].
 */
@PulumiTagMarker
public class ObjectCopyGrantArgsBuilder internal constructor() {
    private var email: Output<String>? = null

    private var id: Output<String>? = null

    private var permissions: Output<List<String>>? = null

    private var type: Output<String>? = null

    private var uri: Output<String>? = null

    /**
     * @param value Email address of the grantee. Used only when `type` is `AmazonCustomerByEmail`.
     */
    @JvmName("kftmmdaspkgfcobf")
    public suspend fun email(`value`: Output<String>) {
        this.email = value
    }

    /**
     * @param value Canonical user ID of the grantee. Used only when `type` is `CanonicalUser`.
     */
    @JvmName("xegdwhtlyslnhpvk")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value List of permissions to grant to grantee. Valid values are `READ`, `READ_ACP`, `WRITE_ACP`, `FULL_CONTROL`.
     */
    @JvmName("ykgwsosnhkossdjq")
    public suspend fun permissions(`value`: Output<List<String>>) {
        this.permissions = value
    }

    @JvmName("mwxtyahtxccvaogv")
    public suspend fun permissions(vararg values: Output<String>) {
        this.permissions = Output.all(values.asList())
    }

    /**
     * @param values List of permissions to grant to grantee. Valid values are `READ`, `READ_ACP`, `WRITE_ACP`, `FULL_CONTROL`.
     */
    @JvmName("txafoluuthptectl")
    public suspend fun permissions(values: List<Output<String>>) {
        this.permissions = Output.all(values)
    }

    /**
     * @param value Type of grantee. Valid values are `CanonicalUser`, `Group`, and `AmazonCustomerByEmail`.
     * This configuration block has the following optional arguments (one of the three is required):
     */
    @JvmName("swaiukufppyoknii")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value URI of the grantee group. Used only when `type` is `Group`.
     */
    @JvmName("jgknwrqsnsvaubxo")
    public suspend fun uri(`value`: Output<String>) {
        this.uri = value
    }

    /**
     * @param value Email address of the grantee. Used only when `type` is `AmazonCustomerByEmail`.
     */
    @JvmName("bppxeinbbnkrxvcr")
    public suspend fun email(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.email = mapped
    }

    /**
     * @param value Canonical user ID of the grantee. Used only when `type` is `CanonicalUser`.
     */
    @JvmName("vvunsgydbsfdgyyf")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value List of permissions to grant to grantee. Valid values are `READ`, `READ_ACP`, `WRITE_ACP`, `FULL_CONTROL`.
     */
    @JvmName("ejriwgxwlskwjrvp")
    public suspend fun permissions(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    /**
     * @param values List of permissions to grant to grantee. Valid values are `READ`, `READ_ACP`, `WRITE_ACP`, `FULL_CONTROL`.
     */
    @JvmName("fgadmwoadisqissp")
    public suspend fun permissions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    /**
     * @param value Type of grantee. Valid values are `CanonicalUser`, `Group`, and `AmazonCustomerByEmail`.
     * This configuration block has the following optional arguments (one of the three is required):
     */
    @JvmName("chhoymnscimolnkr")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value URI of the grantee group. Used only when `type` is `Group`.
     */
    @JvmName("gimwgsutlbbmggxe")
    public suspend fun uri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uri = mapped
    }

    internal fun build(): ObjectCopyGrantArgs = ObjectCopyGrantArgs(
        email = email,
        id = id,
        permissions = permissions ?: throw PulumiNullFieldException("permissions"),
        type = type ?: throw PulumiNullFieldException("type"),
        uri = uri,
    )
}
