@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property blockPublicAcls Whether Amazon S3 should block public ACLs for buckets in this account. Defaults to `true`. Enabling this setting does not affect existing policies or ACLs. When set to `true` causes the following behavior:
 * * PUT Bucket acl and PUT Object acl calls fail if the specified ACL is public.
 * * PUT Object calls fail if the request includes a public ACL.
 * * PUT Bucket calls fail if the request includes a public ACL.
 * @property blockPublicPolicy Whether Amazon S3 should block public bucket policies for buckets in this account. Defaults to `true`. Enabling this setting does not affect existing bucket policies. When set to `true` causes Amazon S3 to:
 * * Reject calls to PUT Bucket policy if the specified bucket policy allows public access.
 * @property ignorePublicAcls Whether Amazon S3 should ignore public ACLs for buckets in this account. Defaults to `true`. Enabling this setting does not affect the persistence of any existing ACLs and doesn't prevent new public ACLs from being set. When set to `true` causes Amazon S3 to:
 * * Ignore all public ACLs on buckets in this account and any objects that they contain.
 * @property restrictPublicBuckets Whether Amazon S3 should restrict public bucket policies for buckets in this account. Defaults to `true`. Enabling this setting does not affect previously stored bucket policies, except that public and cross-account access within any public bucket policy, including non-public delegation to specific accounts, is blocked. When set to `true`:
 * * Only the bucket owner and AWS Services can access buckets with public policies.
 */
public data class AccessPointPublicAccessBlockConfiguration(
    public val blockPublicAcls: Boolean? = null,
    public val blockPublicPolicy: Boolean? = null,
    public val ignorePublicAcls: Boolean? = null,
    public val restrictPublicBuckets: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.s3.outputs.AccessPointPublicAccessBlockConfiguration):
            AccessPointPublicAccessBlockConfiguration = AccessPointPublicAccessBlockConfiguration(
            blockPublicAcls = javaType.blockPublicAcls().map({ args0 -> args0 }).orElse(null),
            blockPublicPolicy = javaType.blockPublicPolicy().map({ args0 -> args0 }).orElse(null),
            ignorePublicAcls = javaType.ignorePublicAcls().map({ args0 -> args0 }).orElse(null),
            restrictPublicBuckets = javaType.restrictPublicBuckets().map({ args0 -> args0 }).orElse(null),
        )
    }
}
