@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property destination Specifies the destination for the exported analytics data (documented below).
 * @property outputSchemaVersion Schema version of exported analytics data. Allowed values: `V_1`. Default value: `V_1`.
 */
public data class AnalyticsConfigurationStorageClassAnalysisDataExport(
    public val destination: AnalyticsConfigurationStorageClassAnalysisDataExportDestination,
    public val outputSchemaVersion: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.s3.outputs.AnalyticsConfigurationStorageClassAnalysisDataExport):
            AnalyticsConfigurationStorageClassAnalysisDataExport =
            AnalyticsConfigurationStorageClassAnalysisDataExport(
                destination = javaType.destination().let({ args0 ->
                    com.pulumi.aws.s3.kotlin.outputs.AnalyticsConfigurationStorageClassAnalysisDataExportDestination.Companion.toKotlin(args0)
                }),
                outputSchemaVersion = javaType.outputSchemaVersion().map({ args0 -> args0 }).orElse(null),
            )
    }
}
