@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bucketAccountId Account ID that owns the destination bucket.
 * @property bucketArn ARN of the destination bucket.
 * @property format Output format of exported analytics data. Allowed values: `CSV`. Default value: `CSV`.
 * @property prefix Prefix to append to exported analytics data.
 */
public data class
AnalyticsConfigurationStorageClassAnalysisDataExportDestinationS3BucketDestination(
    public val bucketAccountId: String? = null,
    public val bucketArn: String,
    public val format: String? = null,
    public val prefix: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.s3.outputs.AnalyticsConfigurationStorageClassAnalysisDataExportDestinationS3BucketDestination):
            AnalyticsConfigurationStorageClassAnalysisDataExportDestinationS3BucketDestination =
            AnalyticsConfigurationStorageClassAnalysisDataExportDestinationS3BucketDestination(
                bucketAccountId = javaType.bucketAccountId().map({ args0 -> args0 }).orElse(null),
                bucketArn = javaType.bucketArn(),
                format = javaType.format().map({ args0 -> args0 }).orElse(null),
                prefix = javaType.prefix().map({ args0 -> args0 }).orElse(null),
            )
    }
}
