@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property grants Set of `grant` configuration blocks. See below.
 * @property owner Configuration block of the bucket owner's display name and ID. See below.
 */
public data class BucketAclV2AccessControlPolicy(
    public val grants: List<BucketAclV2AccessControlPolicyGrant>? = null,
    public val owner: BucketAclV2AccessControlPolicyOwner,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketAclV2AccessControlPolicy):
            BucketAclV2AccessControlPolicy = BucketAclV2AccessControlPolicy(
            grants = javaType.grants().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.s3.kotlin.outputs.BucketAclV2AccessControlPolicyGrant.Companion.toKotlin(args0)
                })
            }),
            owner = javaType.owner().let({ args0 ->
                com.pulumi.aws.s3.kotlin.outputs.BucketAclV2AccessControlPolicyOwner.Companion.toKotlin(args0)
            }),
        )
    }
}
