@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property displayName Display name of the owner.
 * @property emailAddress Email address of the grantee. See [Regions and Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_region) for supported AWS regions where this argument can be specified.
 * @property id Canonical user ID of the grantee.
 * @property type Type of grantee. Valid values: `CanonicalUser`, `AmazonCustomerByEmail`, `Group`.
 * @property uri URI of the grantee group.
 */
public data class BucketAclV2AccessControlPolicyGrantGrantee(
    public val displayName: String? = null,
    public val emailAddress: String? = null,
    public val id: String? = null,
    public val type: String,
    public val uri: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketAclV2AccessControlPolicyGrantGrantee):
            BucketAclV2AccessControlPolicyGrantGrantee = BucketAclV2AccessControlPolicyGrantGrantee(
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            emailAddress = javaType.emailAddress().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            uri = javaType.uri().map({ args0 -> args0 }).orElse(null),
        )
    }
}
