@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property prefix Object key name prefix that identifies the subset of objects to which the configuration applies.
 * @property tags All of these tags must exist in the object's tag set in order for the configuration to apply.
 */
public data class BucketIntelligentTieringConfigurationFilter(
    public val prefix: String? = null,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketIntelligentTieringConfigurationFilter):
            BucketIntelligentTieringConfigurationFilter = BucketIntelligentTieringConfigurationFilter(
            prefix = javaType.prefix().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
