@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accessTier S3 Intelligent-Tiering access tier. Valid values: `ARCHIVE_ACCESS`, `DEEP_ARCHIVE_ACCESS`.
 * @property days Number of consecutive days of no access after which an object will be eligible to be transitioned to the corresponding tier.
 */
public data class BucketIntelligentTieringConfigurationTiering(
    public val accessTier: String,
    public val days: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketIntelligentTieringConfigurationTiering):
            BucketIntelligentTieringConfigurationTiering = BucketIntelligentTieringConfigurationTiering(
            accessTier = javaType.accessTier(),
            days = javaType.days(),
        )
    }
}
