@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property abortIncompleteMultipartUpload Configuration block that specifies the days since the initiation of an incomplete multipart upload that Amazon S3 will wait before permanently removing all parts of the upload. See below.
 * @property expiration Configuration block that specifies the expiration for the lifecycle of the object in the form of date, days and, whether the object has a delete marker. See below.
 * @property filter Configuration block used to identify objects that a Lifecycle Rule applies to. See below. If not specified, the `rule` will default to using `prefix`.
 * @property id Unique identifier for the rule. The value cannot be longer than 255 characters.
 * @property noncurrentVersionExpiration Configuration block that specifies when noncurrent object versions expire. See below.
 * @property noncurrentVersionTransitions Set of configuration blocks that specify the transition rule for the lifecycle rule that describes when noncurrent objects transition to a specific storage class. See below.
 * @property prefix **DEPRECATED** Use `filter` instead. This has been deprecated by Amazon S3. Prefix identifying one or more objects to which the rule applies. Defaults to an empty string (`""`) if `filter` is not specified.
 * @property status Whether the rule is currently being applied. Valid values: `Enabled` or `Disabled`.
 * @property transitions Set of configuration blocks that specify when an Amazon S3 object transitions to a specified storage class. See below.
 */
public data class BucketLifecycleConfigurationV2Rule(
    public val abortIncompleteMultipartUpload:
    BucketLifecycleConfigurationV2RuleAbortIncompleteMultipartUpload? = null,
    public val expiration: BucketLifecycleConfigurationV2RuleExpiration? = null,
    public val filter: BucketLifecycleConfigurationV2RuleFilter? = null,
    public val id: String,
    public val noncurrentVersionExpiration:
    BucketLifecycleConfigurationV2RuleNoncurrentVersionExpiration? = null,
    public val noncurrentVersionTransitions:
    List<BucketLifecycleConfigurationV2RuleNoncurrentVersionTransition>? = null,
    @Deprecated(
        message = """
  Use filter instead
  """,
    )
    public val prefix: String? = null,
    public val status: String,
    public val transitions: List<BucketLifecycleConfigurationV2RuleTransition>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketLifecycleConfigurationV2Rule):
            BucketLifecycleConfigurationV2Rule = BucketLifecycleConfigurationV2Rule(
            abortIncompleteMultipartUpload = javaType.abortIncompleteMultipartUpload().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.s3.kotlin.outputs.BucketLifecycleConfigurationV2RuleAbortIncompleteMultipartUpload.Companion.toKotlin(args0)
                })
            }).orElse(null),
            expiration = javaType.expiration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.s3.kotlin.outputs.BucketLifecycleConfigurationV2RuleExpiration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            filter = javaType.filter().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.s3.kotlin.outputs.BucketLifecycleConfigurationV2RuleFilter.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            noncurrentVersionExpiration = javaType.noncurrentVersionExpiration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.s3.kotlin.outputs.BucketLifecycleConfigurationV2RuleNoncurrentVersionExpiration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            noncurrentVersionTransitions = javaType.noncurrentVersionTransitions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.s3.kotlin.outputs.BucketLifecycleConfigurationV2RuleNoncurrentVersionTransition.Companion.toKotlin(args0)
                })
            }),
            prefix = javaType.prefix().map({ args0 -> args0 }).orElse(null),
            status = javaType.status(),
            transitions = javaType.transitions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.s3.kotlin.outputs.BucketLifecycleConfigurationV2RuleTransition.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
