@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property date Date the object is to be moved or deleted. The date value must be in [RFC3339 full-date format](https://datatracker.ietf.org/doc/html/rfc3339#section-5.6) e.g. `2023-08-22`.
 * @property days Lifetime, in days, of the objects that are subject to the rule. The value must be a non-zero positive integer.
 * @property expiredObjectDeleteMarker Indicates whether Amazon S3 will remove a delete marker with no noncurrent versions. If set to `true`, the delete marker will be expired; if set to `false` the policy takes no action.
 */
public data class BucketLifecycleConfigurationV2RuleExpiration(
    public val date: String? = null,
    public val days: Int? = null,
    public val expiredObjectDeleteMarker: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketLifecycleConfigurationV2RuleExpiration):
            BucketLifecycleConfigurationV2RuleExpiration = BucketLifecycleConfigurationV2RuleExpiration(
            date = javaType.date().map({ args0 -> args0 }).orElse(null),
            days = javaType.days().map({ args0 -> args0 }).orElse(null),
            expiredObjectDeleteMarker = javaType.expiredObjectDeleteMarker().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
