@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property objectSizeGreaterThan Minimum object size to which the rule applies. Value must be at least `0` if specified.
 * @property objectSizeLessThan Maximum object size to which the rule applies. Value must be at least `1` if specified.
 * @property prefix Prefix identifying one or more objects to which the rule applies.
 * @property tags Key-value map of resource tags. All of these tags must exist in the object's tag set in order for the rule to apply.
 */
public data class BucketLifecycleConfigurationV2RuleFilterAnd(
    public val objectSizeGreaterThan: Int? = null,
    public val objectSizeLessThan: Int? = null,
    public val prefix: String? = null,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketLifecycleConfigurationV2RuleFilterAnd):
            BucketLifecycleConfigurationV2RuleFilterAnd = BucketLifecycleConfigurationV2RuleFilterAnd(
            objectSizeGreaterThan = javaType.objectSizeGreaterThan().map({ args0 -> args0 }).orElse(null),
            objectSizeLessThan = javaType.objectSizeLessThan().map({ args0 -> args0 }).orElse(null),
            prefix = javaType.prefix().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
