@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property abortIncompleteMultipartUploadDays Specifies the number of days after initiating a multipart upload when the multipart upload must be completed.
 * @property enabled Specifies lifecycle rule status.
 * @property expiration Specifies a period in the object's expire (documented below).
 * @property id Unique identifier for the rule. Must be less than or equal to 255 characters in length.
 * @property noncurrentVersionExpiration Specifies when noncurrent object versions expire (documented below).
 * @property noncurrentVersionTransitions Specifies when noncurrent object versions transitions (documented below).
 * At least one of `abort_incomplete_multipart_upload_days`, `expiration`, `transition`, `noncurrent_version_expiration`, `noncurrent_version_transition` must be specified.
 * @property prefix Object key prefix identifying one or more objects to which the rule applies.
 * @property tags Specifies object tags key and value.
 * @property transitions Specifies a period in the object's transitions (documented below).
 */
public data class BucketLifecycleRule(
    public val abortIncompleteMultipartUploadDays: Int? = null,
    public val enabled: Boolean,
    public val expiration: BucketLifecycleRuleExpiration? = null,
    public val id: String? = null,
    public val noncurrentVersionExpiration: BucketLifecycleRuleNoncurrentVersionExpiration? = null,
    public val noncurrentVersionTransitions: List<BucketLifecycleRuleNoncurrentVersionTransition>? =
        null,
    public val prefix: String? = null,
    public val tags: Map<String, String>? = null,
    public val transitions: List<BucketLifecycleRuleTransition>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketLifecycleRule):
            BucketLifecycleRule = BucketLifecycleRule(
            abortIncompleteMultipartUploadDays = javaType.abortIncompleteMultipartUploadDays().map({ args0 ->
                args0
            }).orElse(null),
            enabled = javaType.enabled(),
            expiration = javaType.expiration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.s3.kotlin.outputs.BucketLifecycleRuleExpiration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            noncurrentVersionExpiration = javaType.noncurrentVersionExpiration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.s3.kotlin.outputs.BucketLifecycleRuleNoncurrentVersionExpiration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            noncurrentVersionTransitions = javaType.noncurrentVersionTransitions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.s3.kotlin.outputs.BucketLifecycleRuleNoncurrentVersionTransition.Companion.toKotlin(args0)
                })
            }),
            prefix = javaType.prefix().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            transitions = javaType.transitions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.s3.kotlin.outputs.BucketLifecycleRuleTransition.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
