@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property date Specifies the date after which you want the corresponding action to take effect.
 * @property days Specifies the number of days after object creation when the specific rule action takes effect.
 * @property expiredObjectDeleteMarker On a versioned bucket (versioning-enabled or versioning-suspended bucket), you can add this element in the lifecycle configuration to direct Amazon S3 to delete expired object delete markers. This cannot be specified with Days or Date in a Lifecycle Expiration Policy.
 */
public data class BucketLifecycleRuleExpiration(
    public val date: String? = null,
    public val days: Int? = null,
    public val expiredObjectDeleteMarker: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketLifecycleRuleExpiration):
            BucketLifecycleRuleExpiration = BucketLifecycleRuleExpiration(
            date = javaType.date().map({ args0 -> args0 }).orElse(null),
            days = javaType.days().map({ args0 -> args0 }).orElse(null),
            expiredObjectDeleteMarker = javaType.expiredObjectDeleteMarker().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
