@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property targetBucket The name of the bucket that will receive the log objects.
 * @property targetPrefix To specify a key prefix for log objects.
 */
public data class BucketLogging(
    public val targetBucket: String,
    public val targetPrefix: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketLogging): BucketLogging =
            BucketLogging(
                targetBucket = javaType.targetBucket(),
                targetPrefix = javaType.targetPrefix().map({ args0 -> args0 }).orElse(null),
            )
    }
}
