@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property grantee Configuration block for the person being granted permissions. See below.
 * @property permission Logging permissions assigned to the grantee for the bucket. Valid values: `FULL_CONTROL`, `READ`, `WRITE`.
 */
public data class BucketLoggingV2TargetGrant(
    public val grantee: BucketLoggingV2TargetGrantGrantee,
    public val permission: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketLoggingV2TargetGrant):
            BucketLoggingV2TargetGrant = BucketLoggingV2TargetGrant(
            grantee = javaType.grantee().let({ args0 ->
                com.pulumi.aws.s3.kotlin.outputs.BucketLoggingV2TargetGrantGrantee.Companion.toKotlin(args0)
            }),
            permission = javaType.permission(),
        )
    }
}
