@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property prefix Object prefix for filtering (singular).
 * @property tags Object tags for filtering (up to 10).
 */
public data class BucketMetricFilter(
    public val prefix: String? = null,
    public val tags: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketMetricFilter): BucketMetricFilter =
            BucketMetricFilter(
                prefix = javaType.prefix().map({ args0 -> args0 }).orElse(null),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            )
    }
}
