@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property events [Event](http://docs.aws.amazon.com/AmazonS3/latest/dev/NotificationHowTo.html#notification-how-to-event-types-and-destinations) for which to send notifications.
 * @property filterPrefix Object key name prefix.
 * @property filterSuffix Object key name suffix.
 * @property id Unique identifier for each of the notification configurations.
 * @property topicArn SNS topic ARN.
 */
public data class BucketNotificationTopic(
    public val events: List<String>,
    public val filterPrefix: String? = null,
    public val filterSuffix: String? = null,
    public val id: String? = null,
    public val topicArn: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketNotificationTopic):
            BucketNotificationTopic = BucketNotificationTopic(
            events = javaType.events().map({ args0 -> args0 }),
            filterPrefix = javaType.filterPrefix().map({ args0 -> args0 }).orElse(null),
            filterSuffix = javaType.filterSuffix().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            topicArn = javaType.topicArn(),
        )
    }
}
