@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property days The number of days that you want to specify for the default retention period.
 * @property mode The default Object Lock retention mode you want to apply to new objects placed in this bucket. Valid values are `GOVERNANCE` and `COMPLIANCE`.
 * @property years The number of years that you want to specify for the default retention period.
 * Either `days` or `years` must be specified, but not both.
 * > **NOTE on `object_lock_configuration`:** You can only enable S3 Object Lock for new buckets. If you need to turn on S3 Object Lock for an existing bucket, please contact AWS Support.
 * When you create a bucket with S3 Object Lock enabled, Amazon S3 automatically enables versioning for the bucket.
 * Once you create a bucket with S3 Object Lock enabled, you can't disable Object Lock or suspend versioning for the bucket.
 */
public data class BucketObjectLockConfigurationRuleDefaultRetention(
    public val days: Int? = null,
    public val mode: String,
    public val years: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketObjectLockConfigurationRuleDefaultRetention):
            BucketObjectLockConfigurationRuleDefaultRetention =
            BucketObjectLockConfigurationRuleDefaultRetention(
                days = javaType.days().map({ args0 -> args0 }).orElse(null),
                mode = javaType.mode(),
                years = javaType.years().map({ args0 -> args0 }).orElse(null),
            )
    }
}
