@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property days Number of days that you want to specify for the default retention period.
 * @property mode Default Object Lock retention mode you want to apply to new objects placed in the specified bucket. Valid values: `COMPLIANCE`, `GOVERNANCE`.
 * @property years Number of years that you want to specify for the default retention period.
 */
public data class BucketObjectLockConfigurationV2RuleDefaultRetention(
    public val days: Int? = null,
    public val mode: String? = null,
    public val years: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketObjectLockConfigurationV2RuleDefaultRetention):
            BucketObjectLockConfigurationV2RuleDefaultRetention =
            BucketObjectLockConfigurationV2RuleDefaultRetention(
                days = javaType.days().map({ args0 -> args0 }).orElse(null),
                mode = javaType.mode().map({ args0 -> args0 }).orElse(null),
                years = javaType.years().map({ args0 -> args0 }).orElse(null),
            )
    }
}
