@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property deleteMarkerReplication Whether delete markers are replicated. This argument is only valid with V2 replication configurations (i.e., when `filter` is used)documented below.
 * @property destination Specifies the destination for the rule. See below.
 * @property existingObjectReplication Replicate existing objects in the source bucket according to the rule configurations. See below.
 * @property filter Filter that identifies subset of objects to which the replication rule applies. See below. If not specified, the `rule` will default to using `prefix`.
 * @property id Unique identifier for the rule. Must be less than or equal to 255 characters in length.
 * @property prefix Object key name prefix identifying one or more objects to which the rule applies. Must be less than or equal to 1024 characters in length. Defaults to an empty string (`""`) if `filter` is not specified.
 * @property priority Priority associated with the rule. Priority should only be set if `filter` is configured. If not provided, defaults to `0`. Priority must be unique between multiple rules.
 * @property sourceSelectionCriteria Specifies special object selection criteria. See below.
 * @property status Status of the rule. Either `"Enabled"` or `"Disabled"`. The rule is ignored if status is not "Enabled".
 */
public data class BucketReplicationConfigRule(
    public val deleteMarkerReplication: BucketReplicationConfigRuleDeleteMarkerReplication? = null,
    public val destination: BucketReplicationConfigRuleDestination,
    public val existingObjectReplication: BucketReplicationConfigRuleExistingObjectReplication? =
        null,
    public val filter: BucketReplicationConfigRuleFilter? = null,
    public val id: String? = null,
    @Deprecated(
        message = """
  Use filter instead
  """,
    )
    public val prefix: String? = null,
    public val priority: Int? = null,
    public val sourceSelectionCriteria: BucketReplicationConfigRuleSourceSelectionCriteria? = null,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketReplicationConfigRule):
            BucketReplicationConfigRule = BucketReplicationConfigRule(
            deleteMarkerReplication = javaType.deleteMarkerReplication().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.s3.kotlin.outputs.BucketReplicationConfigRuleDeleteMarkerReplication.Companion.toKotlin(args0)
                })
            }).orElse(null),
            destination = javaType.destination().let({ args0 ->
                com.pulumi.aws.s3.kotlin.outputs.BucketReplicationConfigRuleDestination.Companion.toKotlin(args0)
            }),
            existingObjectReplication = javaType.existingObjectReplication().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.s3.kotlin.outputs.BucketReplicationConfigRuleExistingObjectReplication.Companion.toKotlin(args0)
                })
            }).orElse(null),
            filter = javaType.filter().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.s3.kotlin.outputs.BucketReplicationConfigRuleFilter.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            prefix = javaType.prefix().map({ args0 -> args0 }).orElse(null),
            priority = javaType.priority().map({ args0 -> args0 }).orElse(null),
            sourceSelectionCriteria = javaType.sourceSelectionCriteria().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.s3.kotlin.outputs.BucketReplicationConfigRuleSourceSelectionCriteria.Companion.toKotlin(args0)
                })
            }).orElse(null),
            status = javaType.status(),
        )
    }
}
