@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property accessControlTranslation Configuration block that specifies the overrides to use for object owners on replication. See below. Specify this only in a cross-account scenario (where source and destination bucket owners are not the same), and you want to change replica ownership to the AWS account that owns the destination bucket. If this is not specified in the replication configuration, the replicas are owned by same AWS account that owns the source object. Must be used in conjunction with `account` owner override configuration.
 * @property account Account ID to specify the replica ownership. Must be used in conjunction with `access_control_translation` override configuration.
 * @property bucket ARN of the bucket where you want Amazon S3 to store the results.
 * @property encryptionConfiguration Configuration block that provides information about encryption. See below. If `source_selection_criteria` is specified, you must specify this element.
 * @property metrics Configuration block that specifies replication metrics-related settings enabling replication metrics and events. See below.
 * @property replicationTime Configuration block that specifies S3 Replication Time Control (S3 RTC), including whether S3 RTC is enabled and the time when all objects and operations on objects must be replicated. See below. Replication Time Control must be used in conjunction with `metrics`.
 * @property storageClass The [storage class](https://docs.aws.amazon.com/AmazonS3/latest/API/API_Destination.html#AmazonS3-Type-Destination-StorageClass) used to store the object. By default, Amazon S3 uses the storage class of the source object to create the object replica.
 */
public data class BucketReplicationConfigRuleDestination(
    public val accessControlTranslation:
    BucketReplicationConfigRuleDestinationAccessControlTranslation? = null,
    public val account: String? = null,
    public val bucket: String,
    public val encryptionConfiguration: BucketReplicationConfigRuleDestinationEncryptionConfiguration? =
        null,
    public val metrics: BucketReplicationConfigRuleDestinationMetrics? = null,
    public val replicationTime: BucketReplicationConfigRuleDestinationReplicationTime? = null,
    public val storageClass: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketReplicationConfigRuleDestination):
            BucketReplicationConfigRuleDestination = BucketReplicationConfigRuleDestination(
            accessControlTranslation = javaType.accessControlTranslation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.s3.kotlin.outputs.BucketReplicationConfigRuleDestinationAccessControlTranslation.Companion.toKotlin(args0)
                })
            }).orElse(null),
            account = javaType.account().map({ args0 -> args0 }).orElse(null),
            bucket = javaType.bucket(),
            encryptionConfiguration = javaType.encryptionConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.s3.kotlin.outputs.BucketReplicationConfigRuleDestinationEncryptionConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            metrics = javaType.metrics().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.s3.kotlin.outputs.BucketReplicationConfigRuleDestinationMetrics.Companion.toKotlin(args0)
                })
            }).orElse(null),
            replicationTime = javaType.replicationTime().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.s3.kotlin.outputs.BucketReplicationConfigRuleDestinationReplicationTime.Companion.toKotlin(args0)
                })
            }).orElse(null),
            storageClass = javaType.storageClass().map({ args0 -> args0 }).orElse(null),
        )
    }
}
