@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.s3.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property eventThreshold Configuration block that specifies the time threshold for emitting the `s3:Replication:OperationMissedThreshold` event. See below.
 * @property status Status of the Destination Metrics. Either `"Enabled"` or `"Disabled"`.
 */
public data class BucketReplicationConfigRuleDestinationMetrics(
    public val eventThreshold: BucketReplicationConfigRuleDestinationMetricsEventThreshold? = null,
    public val status: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.s3.outputs.BucketReplicationConfigRuleDestinationMetrics):
            BucketReplicationConfigRuleDestinationMetrics =
            BucketReplicationConfigRuleDestinationMetrics(
                eventThreshold = javaType.eventThreshold().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.s3.kotlin.outputs.BucketReplicationConfigRuleDestinationMetricsEventThreshold.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                status = javaType.status(),
            )
    }
}
